<?php

namespace App\Models\fcmodels;

use Illuminate\Database\Eloquent\Model;

class Contact extends Model
{
    protected $connection = 'mysql_newfc';
    protected $primaryKey = 'contact_id';
    protected $table = 'contacts';
  
    protected $fillable = [
        'contact_id',
        'name',
        'phone',
        'group_id',
        'organization_id',
        'status'
    ];       

 //Contacts<>Org relationship
 public function contactOrg()
 {
     return $this->belongsTo(Organization::class,'organization_id');
 }
 //Contacts<>Group relationship
 public function contactGroup()
 {
     return $this->belongsTo(Group::class,'group_id');
 }
}
