<?php

namespace App\Http\Controllers\WarrantControllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Hash;
use App\Models\fcmodels\Ime_Trial;
use App\Models\atmodels\Airtime_customer;
use App\Models\atmodels\Airtime_contact; //contatcs
use App\Models\atmodels\Airtime_sending_record; //expenditure
use App\Models\atmodels\Currency_credit; //balance
use App\Models\atmodels\CreditTopup; //topups
use App\Models\atmodels\Airtime_group; //groups
use App\Models\atmodels\User;
use App\Models\fcmodels\Currency_Expenditure;


use App\Charts\WarrantCharts\WarrantyChart;
use EloquentBuilder;
use App\Models\fcmodels\Organization;
use  App\Charts\NewChart;
use App\Models\fcmodels\Shop;
use App\Models\fcmodels\Ivr;
use App\Models\fcmodels\Incoming;
use App\Models\fcmodels\Wallet;
class WarrantUserController extends Controller
{
    public function dashboard()
    {
        //
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $groups=Airtime_group::where('customer_id',$customer_id)->get();
            $topups=CreditTopup::where('shop_id',$shop_id)->sum('credit_amount');
            $balance=Currency_credit::where('shopid',$shop_id)->pluck('amount'); 
            $expenditure=Airtime_sending_record::where('customer_id',$customer_id)->sum('airtime_sent');
            $contacts = Airtime_contact::where('customer_id',$customer_id)->with('contactGroup')->get();
            $search ='Dear Customer you have received';
            //recent topups
            $expenditure_recent=Currency_Expenditure::where('sms','LIKE', '%'.$search.'%')->latest('date_time')->take(2)->get();
          
            //$recent_warrant_checks=Ime_Trial::where('to_shortcode','20384')->latest('created_at')->take(4)->get();
            $recent_warrant_checks=Ime_Trial::where('status','1')->get()->count();
            $recent_warrant_checks_invalid=Ime_Trial::where('status','0')->get()->count();
            $recent_warrant_checks_all=Ime_Trial::count();
            //recent my account tpups
            $topups_recent=CreditTopup::where('shop_id',$shop_id)->latest('topup_time')->take(2)->get();
            
              $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount'); 
             
              $id = Auth::user()->organization_id;
              $api_account = Auth::user()->api_account;
              
             
              $today = date('Y-m-d');
                  

                      
              $query =Ime_Trial::where('to_shortcode','20384');
              $warrantycountall=EloquentBuilder::to($query,request()->all())->count();
                      
              $query =Ime_Trial::where('to_shortcode','20384')->where('status','1');
              $warrantycountSuccess=EloquentBuilder::to($query,request()->all())->count();
                      
              $query =Ime_Trial::where('to_shortcode','20384')->where('status','0');
              $warrantycountfailed=EloquentBuilder::to($query,request()->all())->count();
    

                      
              $borderColors = [ "#30ba35", "#f25961" ];
              $fillColors = ["#f00","#59d05d" ];
              $chart1 = new WarrantyChart;
              // $chart1->minimalist(true);
              $chart1->labels(['InValid','valid']);
              $chart1->dataset('Warranty Statistics', 'pie',[$warrantycountfailed,$warrantycountSuccess])
              // ->color($borderColors)
              ->backgroundcolor($fillColors);
                                          
              return view('warrantviews.user-dashboard',compact('chart1','warrantycountall','warrantycountSuccess','warrantycountfailed','recent_warrant_checks_all','recent_warrant_checks_invalid','wallet','contacts','expenditure','balance','topups','groups','expenditure_recent','topups_recent','recent_warrant_checks'));
        }
        else{
            return abort('401');
        }
      
    }

   //return Airtime_customer view
   public function index()
   {

       if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
       {
      $usersd = Auth::user()->user_type;
           $shop_id=Auth::user()->shop_id;
         
           $customer_id=Auth::user()->userShopUser['customer_id'];
           $company = Airtime_customer::where('customer_id',$customer_id)->pluck("company");
           $userShopCustomer= Auth::user()->userShopCustomer['Name'];
           $airtimecustomeruser = Airtime_customer::where('company',$userShopCustomer)->get();
           $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');
           return view('bundleviews.bundlesuser.index',compact('airtimecustomeruser','wallet'));
       }
       else{
           return abort(401);
       }
   }


//store
public function storeCustomerUser(Request $request)
{
  
     if(Auth::check())
    {
        $id = Auth::user()->organization_id;
        $api_account = Auth::user()->api_account;
    }
    else{
        return abort('401');
    } 
    $request->validate([
    
        'fname' => 'required',

        'fname' => 'required|min:3|max:50',
        'email' => 'email',
        'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
        'password_confirmation' => 'min:6'      
            ]);
        
    $userShopCustomer= Auth::user()->userShopCustomer['Name'];
    
    $data = new Airtime_customer();
    $data->fname = $request->fname;
    $data->lname = $request->lname;
    $data->username = $request->username;
    $data->pwd_xdm_ps = Hash::make($request->password);
    $data->phone = $request->phone;
    $data->email = $request->email;
    $data->user_type = 'normal';
    $data->status = 'Active';
    $data->company =$userShopCustomer;
    
    $data->save ();

    
    $userdata = new User();
    $userdata->username = $request->username;
    $userdata->password = Hash::make($request->password);
    $userdata->shop_id = Auth::user()->shop_id;
    $userdata->user_type = 'organization_user';
    $userdata->email = $request->email;
    $userdata->remember_token = '';
    
    $userdata->save ();

    //log
    // $adminLog = new AuditLog();
    // $adminLog->audit_module = "Organization";
    // $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .$id;
   
    // $adminLog->user_category = "Admin";
    // $adminLog->user_id = $id;
    // ;
    // $adminLog->save();
    
    return response()->json($data);


}


//edit grp
public function updateCustomerUser(Request $request)
{
  
    $request->validate([
        'fname' => 'required',
    ]);
    if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
    {
        $shop_id=Auth::user()->shop_id;
        $customer_id=Auth::user()->userShopUser['customer_id'];
    }
    else{
        return abort(401);
    }

    $data = Airtime_customer::findOrFail($request->customer_id);
    $data->fname = $request->fname;
    $data->lname = $request->lname;
    $data->username = $request->username;
    $data->password =  Hash::make($request->password);
    $data->phone = $request->phone;
    $data->email = $request->email;
    $data->user_type = 'normal';
    $data->status = 'Active';
    $data->company = Auth::user()->user_type;
   
    $data->save ();
}


//Update Customer User Password
public function updateCustomerUserPassword(Request $request)
{
  
    $request->validate([
        'fname' => 'required',
    ]);
    if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
    {
        $shop_id=Auth::user()->shop_id;
        $customer_id=Auth::user()->userShopUser['customer_id'];
    }
    else{
        return abort(401);
    }

    $data = Airtime_customer::findOrFail($request->customer_id);
    $data = Airtime_customer::findOrFail($request->customer_id);
    $data->password =  Hash::make($request->password);

    $data->save ();
}





 //delete
 public function destroy(Request $request,$id)
  {

    //find user details to delete
    $admin = Airtime_customer::where('customer_id',$id)->get();
    //set delete
    $deleteAirtimecustomer = Airtime_customer::find($id);
    $deleteAirtimecustomer->delete();
    //set logging
   
    // $adminLog = new AuditLog();
    // $adminLog->audit_module = "Organization";
    // $adminLog->audit_activity = "Organization of details: ".$admin." deleted by Admin ID#" .$id;
    
    // $adminLog->user_category = "organization";
    // $adminLog->user_id = $id; 
    // $adminLog->save();
}

//api customer
public function storeCustomer(Request $request)
{
   
    return response()->json($request);
     
    $userdata = new User();
    $userdata->username = $request->username;
    $userdata->password = Hash::make($request->password);
    $userdata->shop_id = $request->shop_id;
    $userdata->user_type = 'organization';
    $userdata->email = $request->email;
    
    $userdata->save ();    

}

}
