<?php

namespace App\Http\Controllers\BundlesControllers;

use App\Models\Currency_expenditure;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\atmodels\Shop;
use App\Models\atmodels\CreditTopup;
use App\Models\fcmodels\ApiTopup;
use App\Models\atmodels\Currency_credit;
use App\Models\atmodels\DataBundlesCredits;
use App\Models\bundles\Data_Bundles_TopUp;
use App\Models\atmodels\Logs;
use App\Models\atmodels\IMELogs;

use Auth;
use Exception;
use Hash;
use EloquentBuilder;
use Carbon\Carbon;
class BundlesCurrencyExpenditureController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Currency_expenditure  $currency_expenditure
     * @return \Illuminate\Http\Response
     */
    public function show(Currency_expenditure $currency_expenditure)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Currency_expenditure  $currency_expenditure
     * @return \Illuminate\Http\Response
     */
    public function edit(Currency_expenditure $currency_expenditure)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Currency_expenditure  $currency_expenditure
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Currency_expenditure $currency_expenditure)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Currency_expenditure  $currency_expenditure
     * @return \Illuminate\Http\Response
     */
    public function destroy(Currency_expenditure $currency_expenditure)
    {
        //
    }

    public function bundlestopup()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort('401');
        }

        $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');
        $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount');
        //fetch all trans
        $account=Shop::where('ShopID',$shop_id)->pluck('mpesa_account_name');
         //$trans = ApiTopup::where('BillRefNumber',$account)->get();

        // return response()->json($customer_id);
        return view('bundleviews.currencycredit.topup',compact('datawallet','wallet','account'));


    }
    public function bundlestopupTransactions(){
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort('401');
        }
        
        $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');   
        $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount');
        //$trans = CreditTopup::where('shop_id',$shop_id)->where('description','!=','Airtime Refund')->get();        
         $query =Data_Bundles_TopUp::where('shopid',$shop_id);
        $trans=EloquentBuilder::to($query,request()->all())->orderBy('data_topup_id','desc')->get();
        
       
        return view('bundleviews.currencycredit.topup_transactions',compact('datawallet','trans','wallet'));

    }




    public function activitylogs(){
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort('401');
        }
        
        $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');   
        $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount');
         $topup_datawallet  = Data_Bundles_TopUp::where('shopid',$shop_id)->where('status','Success')->where('qnty','10')->sum('qnty');
         
        $rt= $topup_datawallet * 100;
          return $rt;
        //$trans = CreditTopup::where('shop_id',$shop_id)->where('description','!=','Airtime Refund')->get();        
         $query =Logs::where('shopid',$shop_id)->with('LogsUsers');
        $activitylogs=EloquentBuilder::to($query,request()->all())->orderBy('log_id','desc')->get();
        
       
        return view('bundleviews.activitylogs.index',compact('datawallet','activitylogs','wallet'));

    }


    public function imeactivitylogs(){
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort('401');
        }
        
        $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');   
        $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount');
        //$trans = CreditTopup::where('shop_id',$shop_id)->where('description','!=','Airtime Refund')->get();        
         $query =IMELogs::where('shopid',$shop_id)->with('LogsUsers');
        $activitylogs=EloquentBuilder::to($query,request()->all())->orderBy('ime_log_id','desc')->get();
        
       
        return view('bundleviews.activitylogs.imeiindex',compact('datawallet','activitylogs','wallet'));

    }



    
    
}
