<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;
use Auth;
use Hash;
use App\Models\bmmodels\CustomerUser;
use App\Models\bmmodels\Customer;

use App\Models\bmmodels\AuditLog;
use Exception;
use ErrorException;
use Facade\Ignition\Exceptions\ViewException as ViewException;
use App\Libs\Mobisky;
use Log;

class CustomerUserController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('auth:customer');
    // }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
    // $user=Auth::guard('admin')->user();
    //return response ()->json($user);
    if(Auth::user()->user_type == 'organization')
    {
      if(isset($id))
      {
        $id = Auth::user()->bulk_cust_id;
        $customerUsers = CustomerUser::where('customer_cust_id', $id)->orderBy('cust_user_id')->get();
        return view('bmviews.users.index', compact('customerUsers','id'));
      }
      else
      {
        return abort(404);
      }
    }
    else
    {
      try{
        $customerUsers = CustomerUser::where('customer_cust_id', $id)->orderBy('cust_user_id')->get();
        return view('bmviews.users.index', compact('customerUsers','id'));
      }
      catch(Exception $e)
      {
        abort(500, $e->getMessage());
      }
      
    }
    // else
    // {
    //   return abort(401);
    // }


       // return view('users.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        try
        {
          $id = Auth::user()->bulk_cust_id;
          return view('bmviews.users.create', compact('id'));
        }
        catch(ErrorException $e)
        {
          abort(401, $e->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    //vue addUser
    public function addUser(Request $request)
    {
      //
      request()->validate([
        'surname' => 'required',
        'username' => 'required',
        'othername' => 'required',
        'contact' => 'required',
        'email' => 'required|email',
      ]);
      
      //get username and password for mobisky sms api
         $mobiskysms=app('App\Http\Controllers\BMControllers\ServiceCredentialController')->mobiskySettings();
                
        //read the values from the settings after db mapping
         $sms_username=\Config::get('outpost.sms_username');
         $sms_password=\Config::get('outpost.sms_password'); 

         $smsobject=new Mobisky('demo1','mob1d3m01');
         $otp_code=strtoupper(substr(Hash::make($smsobject->codeGenerator(6)),4,6));
         $otp=$otp_code."0";
        
      
        $customerUser = new CustomerUser();
        $customerUser->cust_user_surname = $request->surname;
        $customerUser->cust_user_othername = $request->othername;
        $customerUser->cust_user_contact = $request->contact;
        $customerUser->email = $request->email;
        $customerUser->cust_user_username = $request->username;
        //append once emails work
        $customerUser->cust_user_first_time =1;
        
        $customerUser->customer_cust_id = $request->customer_id;
        
        //get customer name
        $customerids=Customer::where('cust_id',$request->customer_id)->first();
        
        
        //default password is the username...USER be advised to change
        $customerUser->password = Hash::make($otp);
        $customerUser->cust_user_status = 1;
        $customerUser->role_id = 3;
        // log data
        $customerUserLog = new AuditLog();
       
        
        if(Auth::user()->user_type == 'organization'){
          $customerUserLog->audit_module = "Customer";
          $customerUserLog->audit_activity = "Customer user ".$customerUser->cust_user_username ."added by Customer ID# " .Auth::user()->bulk_cust_id;
          $customerUserLog->user_category = "Customer";
          $customerUserLog->user_id = Auth::user()->bulk_cust_id;
        }
        else{
          $customerUserLog->audit_module = "Customer";
          $customerUserLog->audit_activity = "Customer user ".$customerUser->cust_user_username ."added by Admin ID# " .Auth::id();
          $customerUserLog->user_category = "Admin";
          $customerUserLog->user_id = Auth::id();
           
        }
        // dd($customer .$customerLog);
        $customerUser->save();
        $customerUserLog->save();
        
        //send a message to the user with some default password
        $phn="254".$request->contact;
        $sms='Dear '.$request->surname.',Welcome to Mobisky Bulk Payments Platform.You account as Initiator Operator has been created for '.$customerids['cust_name'].'.Your username:'.$request->email.' and password:'.$otp.'.Kindly keep the password safely and delete the message.';
        
        Log::info($smsobject->sendMessage($phn,$sms));
        
        //write to csv
        $module=$customerUserLog->audit_module;$activity=$customerUserLog->audit_activity;$user_category=$customerUserLog->user_category;$user_id=$customerUserLog->user_id;$datetime=date('Y-m-d h:i:s');
        $list = array (
        array($module, $activity,  $user_category,$user_id, $datetime),
        );
        
        $file = fopen("csvs/Audit.csv","a+");
        
        foreach ($list as $line) {
        fputcsv($file, $line);
        }
        
        fclose($file);
        // end write to csv
       return response()->json($customerUser);
      
    }
    //vue editUser
    public function editUser(Request $request)
    {
      //
      request()->validate([
        'surname' => 'required',
        'username' => 'required',
        'othername' => 'required',
        'contact' => 'required',
        'email' => 'required',
      ]);
      //current user details
      $id = $request->cust_user_id;
      $customeruserdets = CustomerUser::where('cust_user_id',$id)->get();
      //update
      $customerUser = CustomerUser::find($id);
      $customerUser->cust_user_surname = $request->surname;
        $customerUser->cust_user_othername = $request->othername;
        $customerUser->cust_user_contact = $request->contact;
        $customerUser->email = $request->email;
        $customerUser->cust_user_username = $request->username;
        $customerUser->customer_cust_id = $request->customer_id;
        
        //$customerUser->cust_user_status = $request->cust_user_status;
        // log data
        $customerUserLog = new AuditLog();
        
        
      if(Auth::user()->user_type == 'organization'){
          $customerUserLog->audit_module = "Customer";
          $customerUserLog->audit_activity = "Customer user ".$customerUser->cust_user_username ." update from ".$customeruserdets." to ".$customerUser." by User ID# " .Auth::user()->bulk_cust_id;
          $customerUserLog->user_category = "Customer";
          $customerUserLog->user_id = Auth::user()->bulk_cust_id;
      }
      else {
          $customerUserLog->audit_module = "Admin";
          $customerUserLog->audit_activity = "Customer user ".$customerUser->cust_user_username ." update from ".$customeruserdets." to ".$customerUser." by Admin ID# " .Auth::id();
          $customerUserLog->user_category = "Admin";
          $customerUserLog->user_id = Auth::id();
          }
      
      if($request->password){
          
          $customerUser->password=Hash::make($request->password);
      }
 
      
        // dd($customer .$customerLog);
        $customerUser->save();
        $customerUserLog->save();
        
        //send sms on update
        //get username and password for mobisky sms api
         $mobiskysms=app('App\Http\Controllers\BMControllers\ServiceCredentialController')->mobiskySettings();
                
        //read the values from the settings after db mapping
         $sms_username=\Config::get('outpost.sms_username');
         $sms_password=\Config::get('outpost.sms_password'); 

         $smsobject=new Mobisky('twalisha','twalisha');
         
         //send a message to the user with some default password
        $phn="254".$request->contact;
        
        if($request->password){
          
              $sms='Dear '.$request->surname.',You have edited your account details'."Username: ".$request->email.' and password:'.$request->password;
          }
          else
          {
              $sms='Dear '.$request->surname.',You have edited your account details'."Username: ".$request->email.' and password is your old password';
          }
        
        
        Log::info($smsobject->sendMessage($phn,$sms));
        
         
        //write to csv
        $module=$customerUserLog->audit_module;$activity=$customerUserLog->audit_activity;$user_category=$customerUserLog->user_category;$user_id=$customerUserLog->user_id;$datetime=date('Y-m-d h:i:s');
        $list = array (
        array($module, $activity,  $user_category,$user_id, $datetime),
        );
        
        $file = fopen("csvs/Audit.csv","a+");
        
        foreach ($list as $line) {
        fputcsv($file, $line);
        }
        
        fclose($file);
        // end write to csv
        return response()->json($request->customer_id);
    }
    //vue deleteUser
    public function deleteUser($id)
    {
      //find user
      $customeruserdets = CustomerUser::where('cust_user_id',$id)->get();
      //delete
      $deleteuser = CustomerUser::find($id);
      //log
      $userlog = new AuditLog();
        
         if(Auth::user()->user_type == 'organization'){
              $userlog->audit_module = "Customer";
              $userlog->audit_activity = "Customer user ".$customeruserdets ." deleted  by Customer ID# " .Auth::user()->bulk_cust_id;
              $userlog->user_category = "Customer";
              $userlog->user_id = Auth::user()->bulk_cust_id;
          }else{
              $userlog->audit_module = "Admin";
              $userlog->audit_activity = "Customer user ".$customeruserdets ." deleted  by Admin ID# " .Auth::id();
              $userlog->user_category = "Admin";
              $userlog->user_id = Auth::id();
          }
      //finish
      $deleteuser->delete();
      $userlog->save();

      //write to csv
      $module=$userlog->audit_module;$activity=$userlog->audit_activity;$user_category=$userlog->user_category;$user_id=$userlog->user_id;$datetime=date('Y-m-d h:i:s');
      $list = array (
      array($module, $activity,  $user_category,$user_id, $datetime),
      );
      
      $file = fopen("csvs/Audit.csv","a+");
      
      foreach ($list as $line) {
      fputcsv($file, $line);
      }
      
      fclose($file);
      // end write to csv
    }
    //vue get user
    public function getUser(Request $request)
    {
      $data = CustomerUser::all();
      return $data;
    }
    public function store(Request $request)
    {
        //add customers
      //  try
        {
        request()->validate([
            'cust_user_surname'=> 'required',
            'cust_user_othername' => 'required',
            'cust_user_contact' => 'required',
           
           // 'email' => 'required|unique:users,email',
            'email' => 'required',
            
        ]);
        $customerUser = new CustomerUser();
        $customerUser->cust_user_surname = $request->get('cust_user_surname');
        $customerUser->cust_user_othername = $request->get('cust_user_othername');
        $customerUser->cust_user_contact = $request->get('cust_user_contact');
        $customerUser->email = $request->get('email');
        $customerUser->email = $request->get('email');
        $customerUser->cust_user_override =2; //$request->get('cust_user_override');
        //$customerUser->email = $request->get('email');


        //default password is the username...USER be advised to change
        $customerUser->password = Hash::make(substr(Hash::make($request->get('password')),-8));
        $customerUser->cust_user_status = 1;
        // log data
        if(Auth::user()->user_type == 'organization'){
            $customerUserLog = new AuditLog();
            $customerUserLog->audit_module = "Customer User";
            $customerUserLog->audit_activity = "Customer user".$customerUser->cust_username ."added by Admin ID# " .Auth::user()->bulk_cust_id;
            $customerUserLog->activity_id = 2;
            $customerUserLog->user_category = "Admin";
            $customerUserLog->user_id = Auth::user()->bulk_cust_id;
        }
        else
        {
            $customerUserLog = new AuditLog();
            $customerUserLog->audit_module = "Customer User";
            $customerUserLog->audit_activity = "Customer user".$customerUser->cust_username ."added by Admin ID# " .Auth::id();
            $customerUserLog->activity_id = 2;
            $customerUserLog->user_category = "Admin";
            $customerUserLog->user_id = Auth::id();
        }
            //dd($customer .$customerLog);
        $customerUser->save();
        $customerUserLog->save();
        //write to csv
        $module=$customerUserLog->audit_module;$activity=$customerUserLog->audit_activity;$user_category=$customerUserLog->user_category;$user_id=$customerUserLog->user_id;$datetime=date('Y-m-d h:i:s');
        $list = array (
        array($module, $activity,  $user_category,$user_id, $datetime),
        );
        
        $file = fopen("csvs/Audit.csv","a+");
        
        foreach ($list as $line) {
        fputcsv($file, $line);
        }
        
        fclose($file);
        // end write to csv
         return redirect()->back()
            ->with('success','User Added Succesfully.');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $customerUser = CustomerUser::findOrFail($id);
        return view('bmviews.users.details',compact('customerUser'));


    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //

        $customerUser = customerUser::findOrFail($id);
        return view('users.edit',compact('customerUser'));


      //  return view('users.edit');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      //  try
        {
            request()->validate([
                'cust_user_surname'=> 'required',
                'cust_user_othername' => 'required',
                'cust_user_contact' => 'required',
               
                'email' => 'required|unique:users,email',
                'email' => 'required',
            ]);
        //current customer details
        $customerdets = customerUser::where('cust_user_id',$id)->get();
        //update
        $customerUser = User::find($id);
        $customerUser->cust_user_surname = $request->get('cust_user_surname');
        $customerUser->cust_user_othername = $request->get('cust_user_othername');
        $customerUser->cust_user_contact = $request->get('cust_user_contact');
        $customerUser->email = $request->get('email');
        $customerUser->email = $request->get('email');
        //default password is the username...USER be advised to change
        $customerUser->password = Hash::make($request->get('password'));
        $customerUser->cust_user_status = 1;
        // log data
        $customerUserLog = new AuditLog();
        $customerUserLog->audit_module = "Customer User";
        $customerUserLog->audit_activity = "Customer user".$user->email ."updated by Admin ID# " .Auth::user()->admin_id;
        $customerUserLog->activity_id = 2;
        $customerUserLog->user_category = "Admin";
        $customerUserLog->user_id = Auth::user()->admin_id;
            
  
        //dd($customer .$customerLog);
        $customer->save();
        $customerLog->save();
        //write to csv
        $module=$customerUserLog->audit_module;$activity=$customerUserLog->audit_activity;$user_category=$customerUserLog->user_category;$user_id=$customerUserLog->user_id;$datetime=date('Y-m-d h:i:s');
        $list = array (
        array($module, $activity,  $user_category,$user_id, $datetime),
        );
        
        $file = fopen("csvs/Audit.csv","a+");
        
        foreach ($list as $line) {
        fputcsv($file, $line);
        }
        
        fclose($file);
        // end write to csv
         return redirect()->back()
            ->with('success','Customer Edited Succesfully.');
        }
  
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    
}

