@php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'warrantviews.layouts.customer';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'warrantviews.layouts.user';
}
@endphp
@extends($layout)
@section('content')

<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Warranty Cheks</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Warranty Cheks</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <!--<a href="#" data-target="#add" data-toggle="modal" id="show-modal" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Group</a>-->
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                        <div class="col-md-12">
                            <div class="card full-height">  
                                <div class="card-body">  
                                    @include ('warrantviews.partials.filter-detailedsummary')
                                    
                                    <div class="card-title pull-left">Detailed History Summary</div>
                                        <a class="btn btn-success btn-border btn-round btn-sm pull-right" data-toggle="collapse" data-target="#filter-panel">
                                            <i class="fas fa-filter"></i> Filter
                                        </a>
                
                                        <!-- check if exist -->
                                        @if(!$requests->count())
                                        @include('layouts.nodata')
                                        @else
                                            <div class="table-responsive">
                                            <div class="text-right mb-3 border-bottom pb-1"></div>
                                            <form id="groups-filter-form" class="form" action="{{ route('at.history.excel', request()->all()) }}" role="form">
                                                <a href="{{ route('warrant.history.excel', request()->all()) }}"class="btn btn-sm btn-border btn-round btn-success">Excel</a>
                                                <a href="{{ route('warrant.history.pdf',  request()->all()) }}" class="btn btn-sm btn-border btn-round btn-danger">PDF</a>
                                            </form>
            


                                            <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                            
                                                <th>Message</th>
                                                <th>Status</th>    
                                                <th>Date</th>
                                                <th>From</th>
                             
                                       
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                            
                                                <th>Message</th>
                                                <th>Status</th>    
                                                <th>Date</th>
                                                <th>From</th>
                                               
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($requests as $request)
                                            <tr>
                                           {{--  <td>{{ $request->linkId }}</td>  --}}
                                            <td>{{ $request->text_message }}</td>
                                         
                                            <td>@if($request->status == 1)
                                            <span class="badge badge-success">Valid</span>
                                            @elseif($request->status == 0)
                                            <span class="badge badge-danger">Invalid</span>
                                     
                                           
                                            @endif
                                            </td>

                             
                                            <td>{{ $request->created_at->format('d-m-y h:m') }}</td>
                                            <td>{{ $request->trial_from }}</td>
                 
                                  
                                    
                                            
                                            </tr>
                                            <!-- Edit modal -->
                                            <div class="modal fade" id="edit-{{ $request->role_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit role </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                            <editrole_component :roledata="{{ json_encode($request)}}"/>
                                                        </div>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        <!-- end Edit modal -->
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script src="{{ asset('js/app.js') }}" type="text/js"></script>
        </div>

        <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
<script src='https://unpkg.com/popper.js@1.11.1'></script>
<script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    @endsection

