@php
if(Auth::guard('web')->check())
{
    $layout = 'layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}
elseif(Auth::guard('admin')->check())
{
 $layout = 'layouts.admin';
 $dashboard='admin-dashboard';
 }
 elseif(Auth::guard('customer')->check())
 {
 $layout = 'layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

 }
@endphp
@extends($layout)
@section('content')
<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>

<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Payments</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Payments</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            @if(Auth::guard('web')->check())
                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="true">
                                   <i class="fas fa-plus"></i> Make Payment
                                </button>
                                <ul class="dropdown-menu" role="menu" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -117px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <li>
                                <a href="#" data-toggle="modal" data-target="#payClient" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> Pay contact</a>
                                <a href="#" data-toggle="modal" data-target="#payGroup" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> Pay Group</a>
                                <a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item"><i class="fas fa-file-import"></i> Import contact to pay</a>
                                </li>
                                </ul>
                            </div>
                            @elseif(Auth::guard('customer')->check())
                            <a href="{{route($fdashboard)}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        
                            @endif
                        </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                    
                                    @include ('partials.filter-tests')

                                    <div class="text-right mb-3 border-bottom pb-3">
                                    <div class="card-title pull-left">Payments Details</div>
                                        <a id="traders-export" href="" class="btn btn-primary btn-border btn-round btn-sm">
                                            <i class="far fa-file-excel"></i> Export Excel
                                        </a>
                                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                                            <i class="fas fa-filter"></i> Filter
                                        </a>
                                    </div>

                                    <div id="filter-msg" class="d-none">
                                        <div class="alert alert-info shadow-sm mb-0" role="alert">
                                            <p class="mb-0"><i class="fas fa-info-circle"></i> This is a filtered view. <span id="filters"></span></p>
                                        </div>
                                        <hr>
                                    </div>
                                    <div id="vue-admin-user">
                                       
                                        <!-- tabs -->
                                        <ul class="nav nav-pills nav-secondary" id="pills-tab" role="tablist">
                                            {{-- Initiated payments Tab --}}
                                            <li class="nav-item">
                                                <a class="nav-link active" id="initiated-tab" data-toggle="pill" href="#initiated" role="tab" aria-controls="initiated" aria-selected="true"><i class=""></i> Initiated</a>
                                            </li>

                                            {{-- Succesful Tab --}}
                                                <li class="nav-item">
                                                    <a class="nav-link" id="succesful-tab" data-toggle="pill" href="#successful" role="tab" aria-controls="successful" aria-selected="false"><i class=""></i>  Successful</a>
                                                </li>

                                            {{-- Failed Tab --}}
                                            <li class="nav-item">
                                                <a class="nav-link" id="failed-tab" data-toggle="pill" href="#failed" role="tab" aria-controls="failed" aria-selected="false"><i class=""></i> Failed</a>
                                            </li>
                                        </ul>
                                        <!--/tabs  -->
                                        <br>
                                    <div class="tab-content" id="pills-tabContent">
                                        <div id="initiated" role="tabpanel" aria-labelledby="initiated-tab" class="tab-pane fade show active">
                                        <div class="table-responsive">
                                      
                                            </div>
                                            </div>
                                            <div id="successful" role="tabpanel" aria-labelledby="succesful-tab" class="tab-pane fade">

                                       
                                            </div>
                                            <div id="failed" role="tabpanel" aria-labelledby="failed-tab" class="tab-pane fade">

                                            </div>
                                        </div>
                                        
                                        <!-- pay clients -->
                                        <div class="modal fade" id="payClient" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Pay Contacts</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body bg-light">
                                                            
                                                            <pay_client/>
                                                        </div>
                                                        <div class="modal-footer">
                                                            
                                                        </div>
                                                    </div>
                                            </div>
                                        </div>
                                        <!-- /pay contact -->
                                         <!-- pay groups -->
                                         <div class="modal fade" id="payGroup" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Pay Group(s)</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    
                                                        <div class="modal-body bg-light">
                                                            
                                                            <pay_group/>
                                                        </div>
                                                        <div class="modal-footer">
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /pay groups -->
                                        @if(Auth::guard('web')->check())
                                            <!-- pay import -->              
                                        <div class="modal fade" id="importClient" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Import Contacts</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="{{ route('batchimport', Auth::guard('web')->user()->customer_cust_id)}}" method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body bg-light">
                                                            <div class="alert alert-info shadow-sm">
                                                                <p class="mb-0">Download <a href="{{ url('/sample/clients.xlsx') }}">sample file</a></p>
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="import-file">Select excel file to import*</label>
                                                                <input name="file" id="import-file" type="file" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-success btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-danger btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /pay import -->
                                        
                                        @endif
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
@endsection
@section('scripts')
<script>

        $(document).ready(() => {
            let url = location.href.replace(/\/$/, "");

            if (location.hash) {
                const hash = url.split("#");
                console.log(hash);
                $('#pills-tab a[href="#'+hash[1]+'"]').tab("show");
                url = location.href.replace(/\/#/, "#");
                console.log(url);
                history.replaceState(null, null, url);
                setTimeout(() => {
                    $(window).scrollTop(0);
                }, 0);
            }
        });

</script>
@endsection