@php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
@endphp
@extends($layout)
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">B2B Rates</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>supervise
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">B2B Rates</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="{{ route($dashboard)}}" class="btn btn-white btn-border btn-round mr-2">Back</a>
                    
                        </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Transaction Rates</div>
                                        @if(!$b2brates->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>ID#</th>
                                                    <th>From</th>
                                                    <th>To</th>
                                                    <th>Tariff</th>
                                                    <th>Our Charges(%)</th>
                                                    <th>Safaricom's(%)</th>
                                                    
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>ID#</th>
                                                <th>From</th>
                                                <th>To</th>
                                                <th>Tariff</th>
                                                <th>Our Charges(%)</th>
                                                <th>Safaricom's(%)</th>
                                                
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($b2brates as $rate)
                                            <tr>
                                            <td>{{ $rate->rate_id }}</td>
                                            <td>{{ $rate->rate_min }}</td>
                                            <td>{{ $rate->rate_max }}</td>
                                            <td>{{ $rate->B2BTariff->tariff_name}}</td>
                                            <td>{{ $rate->rate_charge }}</td>
                                            <td>{{ $rate->rate_saf_charges }}</td>
                                           
                                        
                                            </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
            </div>
            </div>
        </div>
    </div>
    @endsection