<form method="POST" action="{{ url('/at/topup/groups') }}">
    @csrf

    <div class="form-group row">
        {{-- Select Group --}}
        <div class="col-md-12">
            <label for="group">Select Group</label>
            <select name="group_id" class="form-control">
                <option value="">-Select Group-</option>
                @foreach($groupdata as $group)
                    <option value="{{ $group->group_id }}">{{ $group->name }}</option>
                @endforeach
            </select>
            @error('group')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        {{-- Amount --}}
        <div class="col-md-12 mt-2">
            <label for="amount">Amount to Send</label>
            <input type="number" name="amount" value="{{ old('amount') }}" class="form-control" placeholder="Ksh">
            @error('amount')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>
    </div>

    {{-- Buttons --}}
    <div class="form-group mt-3">
        <button type="submit" class="btn btn-success btn-round">Submit</button>
        <button type="reset" class="btn btn-danger btn-round">Cancel</button>
    </div>
</form>

{{-- Contacts Table --}}
@if($contactsgroup_names->isEmpty())
    <p>No Data Found</p>
@else
    <table class="table table-bordered">
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Phone</th>
            <th>Group</th>
        </tr>
        @foreach($contactsgroup_names as $index => $category)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $category->fname }}</td>
                <td>{{ $category->contact }}</td>
                <td>
                    {{ $category->group_asso_contacts->name ?? 'Null Value' }}
                </td>
            </tr>
        @endforeach
    </table>

    {{-- Pagination --}}
    <div class="d-flex justify-content-end">
        {{ $contactsgroup_names->links() }}
    </div>
@endif
