<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use App\Models\fcmodels\InboxTag;
use App\Models\fcmodels\Bulksms;
use App\Models\fcmodels\Incoming;
use App\Models\fcmodels\Department;
use Auth;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;

class TaggedController extends Controller
{
    public function index()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
       else{
            return abort('401');
        }
        //return $id;
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $dept = Department::where('organization_id',$id)->pluck('department_id');
        $inboxtags = InboxTag::with('tagsSDep')->whereIn('department_id',$dept)->get();
        return view('fcviews.tagged.index',compact('inboxtags','wallet'));
 
    }
    //show messages with tags
    public function tagged($id)
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $mid = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
       else{
            return abort('401');
        }
     //return $mid;
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $messages = Incoming::where('sms','LIKE','%'.$id.'%')->where('responded_to','')->where('site',$mid)->get();
        return view('fcviews.tagged.tagged-sms',compact('messages','id','wallet'));
    }
    //other untagged
    public function untagged()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
       else{
            return abort('401');
        }
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $dept = Department::where('organization_id',$id)->pluck('department_id');
        $inboxtags = InboxTag::with('tagsSDep')->whereIn('department_id',$dept)->pluck('tag_name');
        $messages = Incoming::whereNotIn('sms',['%'.$inboxtags.'%'])->where('responded_to',NULL)->where('site',$id)->get();
        return view('fcviews.tagged.untagged',compact('messages','wallet'));
 
    }
}
