<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use Auth;
use Hash;
use Exception;
use App\Models\fcmodels\OrganizationUser;
use App\Models\User;
use EloquentBuilder;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\Shop;
use App\Models\fcmodels\Currency_Expenditure;
use App\Mail\OrderShipped;
class OrganizationUserController extends Controller
{
    //
    public function index()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
           
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $users = OrganizationUser::where('organization_id',$id)->get();
        return view('fcviews.organization-user.index',compact('users','wallet'));
    }
    //store
    public function store(Request $request)
    {
          if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        } 
        request()->validate([
            'fname'=> 'required',
            'lname' => 'required',
            'email' => 'required',
            'username' => 'required|unique:'.OrganizationUser::class.',username',
            'role_id' => 'required',
            'password' => 'required|confirmed',
            'password_confirmation' => 'required'
     
        ],
        [
            'fname.required' => 'Please enter first name',
            'lname.required' => 'Please enter last name',
            'email.required' => 'Please enter email address',
            'username.required' => 'Please enter username',
            'username.unique' => 'Username has already been taken, try another one',
            'role_id.required' => 'Please select role',
            'password.required' => 'Please enter password',
            'password.confirmed' => 'Passwords do not match',
            'password_confirmation.required' => 'Please enter a confirmation password',
     
        ]);
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
        $user = new OrganizationUser();
        $user->fname = $request->get('fname');
        $user->lname = $request->get('lname');
        $user->email = $request->get('email');
        $user->username = $request->get('username');
        $user->role_id = $request->role_id['role_id'];
        $user->organization_id = $id;
        
         $user->api_account = $api_account;
       
        $user->password = Hash::make($request->password);
     //$details=$user->fname  $user->lname  $user->username   $user->role_id;
     
     $details="We have created an account for you with username ".$user->username ." and Password ".$user->password." As your Login credentials ";
       
        // log data
       $userLog = new AuditLog();
       $userLog->audit_module = "Organization";
       $userLog->audit_activity = "Organization User ".$user->username ."added by Admin ID# " .$id;
        
       $userLog->user_category = "Organization";
       $userLog->user_id = $id;
        
       $userLog->save();
        $user->save();
        
        //create accounts user
        $cust_id = $id;
        $newuser = new User();
        $newuser->username = $request->get('username');
        $newuser->cust_id = $cust_id;
        $newuser->shop_id = $api_account;
        $newuser->email = $request->get('email');
        $newuser->user_type = 'organization_user';
        $newuser->password = Hash::make($request->password);
        $newuser->save();
        \Mail::to( $user->email)->send(new OrderShipped($details));
        return $user;
    }
    //update
    public function update(Request $request)
    {
        request()->validate([
            'fname'=> 'required',
            'lname' => 'required',
            'email' => 'required',
            'username' => 'required',
            'role_id' => 'required',
     
        ]);
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
        $userdets = OrganizationUser::findOrFail($request->id);
        $user = OrganizationUser::findOrFail($request->id);
        $user->fname = $request->get('fname');
        $user->lname = $request->get('lname');
        $user->email = $request->get('email');
        $user->username = $request->get('username');
         //dd($id);
        $user->role_id = $request->role_id['role_id'];
        $user->organization_id = $id;
        
        if($request->password != '')
        {
            $user->password = Hash::make($request->password);
        }
        // log data
         
       $userLog = new AuditLog();
       $userLog->audit_module = "Organization";
       $userLog->audit_activity = "Organization User ".$user->username ." updated from ".$userdets." to ".$user." by Organization ID# " .$id;
      
       $userLog->user_category = "Organization";
       $userLog->user_id = $id;
        
       $userLog->save();
        $user->save();
        return $user;
    }
    public function delete($id)
    {
       
        $organization = OrganizationUser::where('organization_id',$id)->get();
        //set delete
        $deleteorganization = OrganizationUser::findOrFail($id);
        //set logging
        $organizationLog = new AuditLog();
        $organizationLog->audit_module = "Organization";
        $organizationLog->audit_activity = "Organization with details ".$organization." deleted by Admin ID# ";
        
        $organizationLog->user_category = "Admin";
       // $organizationLog->user_id = Auth::guard('admin')->user()->admin_id;
        //$organizationLog->save();
        $deleteorganization->delete();
    }
}
