<?php

namespace App\Exports;
use EloquentBuilder;
use Maatwebsite\Excel\Excel;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use App\Models\fcmodels\Ime_Trial;
use Illuminate\Http\Request;
use Auth;
use Carbon\Carbon;

use Maatwebsite\Excel\Concerns\FromCollection;

class Ime_TrialExport implements Responsable, FromCollection, WithHeadings, WithMapping
{
    private $fileName;

    use Exportable;
    protected $request;
    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */

 // Get the current date and time
 // Get the current date and time
 public function __construct()
 {
     $current = Carbon::now();
     $this->fileName = $current->format('d-m-y_H-i-s') . 'Warrant_History.xlsx';
 }
 // Create the file name using the current date and time
 
    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    // public function __construct($request)
    // {
    //     $this->request = $request;
    // }

    public function headings(): array
    {
        return [
            'linkId',
            'text_message',
            'to_shortcode',
            'trial_from',
            'status',
        ];
    }

    public function map($history): array
    {
        $contact = Ime_Trial::All();
        return [
            $history->linkId,
            $history->text_message,
            $history->to_shortcode,
            $history->trial_from,
            $history->status,
        ];
    }

    public function collection()
    {
        // return Customer::all();
        $query = Ime_Trial::where('to_shortcode','20384')->get();
       // $history = EloquentBuilder::to($query, request()->all())->get();
        return $query;
    }
}
