@php
if(Auth::check())
{
    $layout = 'fcviews.mobisurvey.layouts.org';
}

@endphp
@extends($layout)
@section('content')

<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Responses from participant  </h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Responses</a>
                                    </li>
                                </ul>
                        </div></div>
                      
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
        
                                    <div class="card-body">
                                        <div class="card-title">Details
                                            <a class="btn btn-sm btn-info btn-border pull-right" href="{{ route('mobisurvey.participantresponsespdf',$id) }}">Print</a>
                                            <p>&nbsp;</p>
                                        </div>
                                        <!-- check if exist -->
                                            @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                <strong>Error! </strong>There were some errors with inputs.
                                                <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                                @endforeach
                                                </ul>
                                                </div>
                                            @endif
                                        @include('layouts.messages')
                                        @if(!$responses->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                            <table  id="table" class="display table table-striped table-hover">
                                                <thead>
                                                <tr>
                                                    <th width="5%">No.</th>
                                                    <th>Quiz.</th>
                                                    <th>Response</th>
                                                    </tr>
                                                </thead>
                                                <tfoot>
                                                <tr>
                                                    <th width="5%">No.</th>
                                                    <th>Quiz.</th>
                                                    <th>Response</th>
                                                </tr>
                                                </tfoot>
                                                <tbody>
                                                @foreach($responses as $response)
                                                <tr>
                                                    <td>{{ $response->responseQuestion ? $response->responseQuestion->number : '' }}</td>
                                                    <td>{{ $response->responseQuestion->question }}</td>         
                                                    <td>{{ $response->response }}</td>   
                                                </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                            
                                            @endif
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection