@php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
 $fdashboard='admin-dashboard';
}
@endphp
@extends($layout)
@section('content')

<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>
<div class="main-panel">
    <div class="content"> 
    <div id="vue-admin-user">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Business Numbers</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>                                       
                                    </li>
                                    <li class="nav-item">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li>
                                        {{$customer_name}}
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Business Numbers</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="{{route($fdashboard)}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            @if(Auth::user()->user_type != 'organization' && Auth::user()->user_type != 'organization_user')
                             <button class="btn btn-white btn-round mr-2" data-toggle="modal" data-target="#add" id="show-modal"><i class="fa fa-plus"></i> Add</button>
                            @endif
                       
                       
                        </div>
                    </div>
                </div>
                <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                
                                    <div class="card-body">
                                    @include ('bmviews.partials.filter-contacts')
                                    <div class="text-right mb-3 border-bottom pb-3">
                                    <div class="card-title pull-left">Business Numbers</div>
                                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                                            <i class="fas fa-filter"></i> Filter
                                        </a>
                                    </div>
                                        @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                            <strong>Error! </strong>There were some errors with inputs.
                                            <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                            </ul>
                                            </div>

                                        @endif
                                        @include('layouts.messages')
                                        @if(!$businessnos->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                <th>Number.</th>
                                                <th>Name</th>
                                                <th>Tariff</th>
                                                <th>Status</th> 
                                                @if(Auth::user()->user_type != 'organization' && Auth::user()->user_type != 'organization_user')
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                @endif
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>Number.</th>
                                                <th>Name</th>
                                                <th>Tariff</th>
                                                <th>Status</th> 
                                               @if(Auth::user()->user_type != 'organization' && Auth::user()->user_type != 'organization_user')
                                                <th class="text-center">Action</th>
                                                @endif
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($businessnos as $CustomerClient)
                                            <tr>
                                                
                                            <td>{{ $CustomerClient->business_number }}</td>
                                            <td>{{ $CustomerClient->account_name }}</td>
                                            <td> {{$CustomerClient->B2BTariff->tariff_name}}</td>
                                            
                                            <td>@if ($CustomerClient->business_number_status == 1)
                                            <span class="badge badge-success">Active</span>
                                            @elseif ($CustomerClient->business_number_status == 0)
                                            <span class="badge badge-danger">Inactive</span>
                                            @endif
                                            </td>
                                            @if(Auth::user()->user_type != 'organization' && Auth::user()->user_type != 'organization_user')
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            
                                            <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#myModalEdit-{{$CustomerClient->business_number_id}}" id="show-modal"><i class="fa fa-edit"></i> </button>

                                            <button  @click.prevent="deleteItem('businessbilldeletepath',{{$CustomerClient->business_number_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>  
                                            
                                            </div>
                                             <!-- modal -->
                                             <div id="myModalEdit-{{$CustomerClient->business_number_id}}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Edit Business<strong></strong></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <form action="{{ route('business-numbers.update') }}" method="post" class="form-group row">
                                                            @csrf
                                                            
                                                            <div class="col-md-12">
                                                                <label>Number</label>
                                                                <input type="hidden" name="business_customer_id" value="{{$CustomerClient->business_customer_id}}">
                                                                <input type="hidden" name="id" value="{{$CustomerClient->business_number_id}}">
                                                                <input type="text" name="business_number" class="form-control" value="{{$CustomerClient->business_number}}">
                                                            </div>
                                                            <div class="col-md-12">
                                                                <label>Name</label>
                                                                <input type="text" name="account_name" class="form-control" value="{{$CustomerClient->account_name}}">
                                                            </div>
                                                            <div class="col-md-12">
                                                                <label>Tariff</label>
                                                               
                                                                <select class="form-control custom-form-control" name="tariff_id" id="tariff_id">
                                                                         <option value=""> Select </option>
                                                                        @foreach ($b2btariffs as $key => $b2btariff)                                                               
                                                                         <option  value="{{ $b2btariff['tariff_id'] }}" {{ old('tariff_id') ? ($b2btariff['tariff_id'] == old('tariff_id') ? "selected='selected'" : "" ) : ""  }}> {{$CustomerClient->B2BTariff->tariff_name}} </option>
                                                                        
                                                                        @endforeach
                                                                </select>
                                                            </div>
                                                            @if(Auth::user()->user_type != 'organization' && Auth::user()->user_type != 'organization_user')
                                                            <div class="col-md-12">
                                                                <label>Status</label>
                                                                @if($CustomerClient->business_number_status == 1)
                                                                <input type="checkbox" name="business_number_status" checked value="1" class="form-control">
                                                                @else
                                                                <input type="checkbox" name="business_number_status" value="0" class="form-control">
                                                                @endif
                                                            </div>
                                                            @endif
                                                            <div class="col-md-12">
                                                                <button class="btn btn-success" type="submit">Save</button>
                                                            </div>
                                                        </form>
                                                        </div>    
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /end modal -->
                                            </td>
                                            @endif
                                            </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                    </div>
                                </div>
                            </div>
                            @endif     </div>
                    <!-- client import -->
            
                                      
            </div>
            </div>
            </div>
        </div>
       

         <!-- add busno modal -->
     
      <div id="add" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Add Business number<strong></strong></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body panel-default bg-light">
                <form action="{{ route('business-numbers.store')}}" method="post" class="form-group row">
                    @csrf
                    <div class="col-md-12">
                        <label>Number</label>
                        <input type="hidden" name="business_customer_id" value="{{$id}}">
                        <input type="text" name="business_number" class="form-control">
                    </div>
                    <div class="col-md-12">
                        <label>Name</label>
                        <input type="text" name="account_name" class="form-control">
                    </div>
                    <div class="col-md-12">
                        <label>Tariff</label>
                        <select class="form-control custom-form-control" name="tariff_id" id="tariff_id">
                                                                         <option value=""> Select </option>
                                                                        @foreach ($b2btariffs as $key => $b2btariff)                                                               
                                                                         <option  value="{{ $b2btariff['tariff_id'] }}" {{ old('tariff_id') ? ($b2btariff['tariff_id'] == old('tariff_id') ? "selected='selected'" : "" ) : ""  }}>{{ $b2btariff['tariff_name'] }} </option>
                                                                        
                                                                        @endforeach
                                                                </select>
                    </div>
                    <div class="col-md-12">
                        <button class="btn btn-success" type="submit">Save</button>
                    </div>
                </form>
                </div>                                                        
            </div>
        </div>
    </div>
    <!-- /end modal -->
    </div>
    </div>
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    @endsection
