<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class B2BTariff extends Model
{
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    //
    protected $table ='b2b_tariff';
    protected $fillable = [
        'tariff_id',
        'tariff_name',
        'tariff_status'
    ];
    protected $primaryKey = 'tariff_id';
    
    //has many business numbers
    public function BusinessNumber()
    {
        return $this->hasMany(BusinessNumber::class, 'business_number_id');
    }
    //has many b2b rates
    public function B2BRate()
    {
        return $this->hasMany(B2BRate::class, 'rate_id');
    }
}