<?php

namespace App\Exports;
use EloquentBuilder;
use Maatwebsite\Excel\Excel;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use App\Models\Customer;
use App\Models\CustomerClientPayment;
class CustomerExport implements Responsable, FromQuery, WithHeadings, WithMapping
{
    use Exportable;
    protected $request;

    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */
    private $fileName = 'customers.xlsx';

    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function headings(): array
    {
        return [
            'Name',
            'Email',
            'Phone',
            'Users',
            'Clients',
            'Total Topups',
            'Contact Payments',
            'B2B Payments',
            'Batch Payments',
            'Actie?',
            'Created At',
        ];
    }

    public function map($customer): array
    {
        return [
            $customer->cust_name,
            $customer->email,
            $customer->cust_primary_contact_type,
            isset($customer->CustomerUsers) ? $customer->CustomerUsers->count() : 0,
            isset($customer->CustomerCLients) ? $customer->CustomerCLients->count() : 0,
            isset($customer->CustomerWallet->WalletTransactions) ? $customer->CustomerWallet->WalletTransactions->sum('wallet_trans_amount') : 0,
            isset($customer->CustomerCLients[0]->cust_client_id) ? CustomerClientPayment::where('customer_client_cust_client_id',$customer->CustomerCLients[0]->cust_client_id)->sum('client_pay_amount') : 0,
            isset($customer->CustomerClientPayment) ? $customer->CustomerClientPayment->sum('client_pay_amount') : 0,
            isset($customer->CustomerCLientBatches->BatchClientPayment) ? CustomerClientPayment::where('customer_client_batch_id',$customer->CustomerCLientBatches->BatchClientPayment[0]->client_batch_id)->sum('client_pay_amount'):0,            
            $customer->cust_status = 1 ? 'Active' : 'Inactive',
            $customer->created_at,
        ];
    }

    public function query()
    {
        // return Customer::all();
        return EloquentBuilder::to(Customer::class, $this->request->all());
        // dd($customer);
    }
}
