<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use DB;
use App\Models\bmmodels\CustomerWalletTransaction;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\CustomerWallet;
use Carbon;
use Log;

class mpesaCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mpesa:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $today_date=date("Y-m-d");
        //update a field in the db
        $items=DB::connection('mysql_temp')->select("select * from api_topups where BillRefNumber LIKE 'bmp.%' AND TransTime LIKE '$today_date%' ");
     
        $x=array();
        foreach($items as $item){
            //get the items to use for transaction
            $transID=$item->TransID;
            $billref=$item->BillRefNumber;
            $amount=$item->TransAmount;
            $contact=$item->MSISDN;
            
            $record=CustomerWalletTransaction::where(['wallet_trans_ref'=>$transID,'wallet_client_username'=>$billref])->get();
            if(count($record)<1){
                //insert the new record in the wallet transactions table and update the wallet
                $user=Customer::where(['cust_username'=>$billref])->first();
                $walletid='';
                $userid=$user['cust_id'];
                
                if($user){
                  //get the wallet id of the user
                  $wallet=CustomerWallet::where(['customer_cust_id'=>$userid])->first();
                  $walletid=$wallet['cust_wallet_id'];
                  
                }
               // Log::info($billref);
                $trans['cust_wallet_cust_wallet_id']=$walletid;
                $trans['wallet_trans_type']='PayBill';
                $trans['wallet_trans_amount']=$amount;
                $trans['wallet_trans_status']=1;
                $trans['wallet_trans_ref']=$transID;
                $trans['wallet_client_username']=$billref;
                $trans['wallet_transact_contact']=$contact;
                
                
                //insert the record
                CustomerWalletTransaction::create($trans);
                //update the wallet by the same amount
                
                $wallettoupdate=CustomerWallet::find($walletid);
                
                $currentamount=$wallettoupdate->cust_wallet_bal;
                
                $updatedamount=$currentamount+$amount;
                
                CustomerWallet::where(['cust_wallet_id'=>$walletid])->update(['cust_wallet_bal'=>$updatedamount]);
                                   
             }
            
            
        }

    }
}
