<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;
use App\Libs\Mpesa\Mpesa;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\CustomerWalletTransaction;
use App\Models\bmmodels\CustomerWallet;
use App\Libs\Mpesa\TransactionCallbacks;
use Illuminate\Support\Facades\Log;
use DB;
use EloquentBuilder;



class MpesaController extends Controller
{
 

    //test mpesa
    public function b2cMpesa(){
      
          $InitiatorName="apitest429";
            $SecurityCredential="SuZOdBFSmlta3RGZkQZyWymhfar8F/GWxs62qVf+E/6Os0a14P03lC8PM0WUs83i+ikFXaGhuT6Ole/t58lupGvlwf3uHABbcVeqZa27LuRHyZsjPq3N+tl7Dw45BwKv1QNZeh3H8zWHSxrNtRrCUco1qZ56l4AXy1d7BMJyanH1NZYf+rkgB3VM3+tFxsDOlB8avE+FKYfP+qUa1EyZGKvxOHCYbUnQCXUIBl8zfxxMq+NA+5ItB7aq+ZK3ARPrt7RJWK62VAaYGtEsufHu63thFu8Fj4UCMopOJII6HC9upLFleZm3dsrEfVAssjprQwWd3/LLmHHuy0Z9IevnCg==";
            $CommandID="BusinessPayment";
            $Amount="100";//"50";
            $PartyA="601429";
            $PartyB="254708374149";
            $Remarks="thanks";
            $QueueTimeOutURL="https://mobisky.biz/test/callbackurl.php"; 
            $ResultURL="https://bmtest.mobigrow.mobisky.biz/api/b2c_result";
            $Occasion="salaries";
            $mpesa=new Mpesa();
            $b2cTransaction=$mpesa->b2c($InitiatorName, $SecurityCredential, $CommandID, $Amount,
            $PartyA, $PartyB, $Remarks, $QueueTimeOutURL, $ResultURL, $Occasion);
            
            
            return response()->json($b2cTransaction);
        
       
    }
    //get the request data from mpesa    
    public function b2cResult(Request $request){
        Log::info($request->all());
    }
    ///////////////////// C2B processes///////////////////////////////////////////////////////
    //register callback urls
    public function registerC2B(){
              
        $ShortCode='600610';
        $ResponseType='Completed';
        $ConfirmationURL='http://bmtest.mobigrow.mobisky.biz/api/c2b_confirmation_request';
        $ValidationURL= 'http://bmtest.mobigrow.mobisky.biz/api/c2b_validate_request';
        $mpesa=new Mpesa();
        $registerc2burls=$mpesa->registerC2BUrls($ShortCode,$ResponseType,$ConfirmationURL,$ValidationURL);
        
        return response()->json($registerc2burls);
    }

    //c2b simulation
    public function c2bMpesa(){
        $mpesa= new Mpesa();
        $ShortCode="600610";
        $CommandID="CustomerPayBillOnline";
        $Amount="100";
        $Msisdn="254708374149";
        //test account that pays into the paybill
        $BillRefNumber="demo@gmail.com";
        $c2bTransaction=$mpesa->c2b($ShortCode, $CommandID, $Amount, $Msisdn, $BillRefNumber );

        return response()->json($c2bTransaction);
    }
    //c2b response data for consumption
    public function validateC2B(Request $request){
       
        $custusername=$request->BillRefNumber;
        //get the walletid using this custusername
        $customer=Customer::where('cust_username',$custusername)->first();
        $id=$customer['cust_id'];
        $walletTrans = new CustomerWalletTransaction();
        $walletTrans->wallet_trans_amount = $request->TransAmount;
        $walletTrans->wallet_trans_type = 'MPESA';
        $walletTrans->wallet_trans_ref = $request->TransID;
        $walletTrans->wallet_client_username =$custusername;
        $walletTrans->wallet_transact_contact = $request->MSISDN;
        $walletTrans->cust_wallet_cust_wallet_id = $id;
        $walletTrans->wallet_trans_status = 1;
        //update waller balance
        $wallet = CustomerWallet::find($id);
        $wallet->cust_wallet_bal += $walletTrans->wallet_trans_amount;
        
        $walletTrans->save();
        $wallet->save();
        
        
    }
   
    public function testConnection(){
        
        $tops=DB::connection('mobisky')->select("select * from api_topups where BillRefNumber LIKE 'BMP.%' ");
        return $tops;
    }
    
    public function testAllUsernames(){
        $tops=DB::connection('mobisky')->select("select BillRefNumber from api_topups where BillRefNumber LIKE 'BMP.%'");
        $itm=[];
        foreach($tops as $top){
            array_push($itm,$top);
        }
        $total=collect($itm)->unique();
        return response()->json($total);
    }



   
}
