<?php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
?>

<?php $__env->startSection('content'); ?>
<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>

<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232;">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Payments</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="<?php echo e(route($dashboard)); ?>">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Payments</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <?php if(Auth::user()->user_type == 'organization_user'): ?>
                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="true">
                                   <i class="fas fa-plus"></i> Make Payment
                                </button>
                                <ul class="dropdown-menu" role="menu" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -117px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <li>
                                <a href="#" data-toggle="modal" data-target="#payClient" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> Pay contact</a>
                                <a href="#" data-toggle="modal" data-target="#payGroup" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> Pay Group</a>
                                <a href="#" data-toggle="modal" data-target="#payBusiness" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> Pay Business</a>
                                <a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item"><i class="fas fa-file-import"></i> Import contact to pay</a>
                                </li>
                                </ul>
                            </div>
                            <?php elseif(Auth::user()->user_type == 'organization'): ?>
                            <a href="<?php echo e(route($fdashboard)); ?>" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                    
                                    <?php echo $__env->make('bmviews.partials.filter-payments', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    <div class="text-right mb-3 border-bottom pb-3">
                                    <div class="card-title pull-left">Payments Details
                                     <small class="badge badge-warning text-warning">Highlighted Rows under successful shows unregistered MPESA recipients</small></div>
                                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                                            <i class="fas fa-filter"></i> Filter
                                        </a>
                                    </div>

                                    <div id="filter-msg" class="d-none">
                                        <div class="alert alert-info shadow-sm mb-0" role="alert">
                                            <p class="mb-0"><i class="fas fa-info-circle"></i> This is a filtered view. <span id="filters"></span></p>
                                        </div>
                                        <hr>
                                    </div>
                                    <div id="vue-admin-user">
                                        
                                        <?php if($errors->any()): ?>
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                            <strong>Error! </strong>There were some errors with inputs.
                                            <ul>
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            </div>

                                        <?php endif; ?>
                                        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <!-- tabs -->
                                        <ul class="nav nav-pills nav-secondary" id="pills-tab" role="tablist">
                                            
                                            <li class="nav-item">
                                                <a class="nav-link active" id="initiated-tab" data-toggle="pill" href="#initiated" role="tab" aria-controls="initiated" aria-selected="true"><i class=""></i> Initiated Pending Approval</a>
                                            </li>

                                            
                                                <li class="nav-item">
                                                    <a class="nav-link" id="succesful-tab" data-toggle="pill" href="#successful" role="tab" aria-controls="successful" aria-selected="false"><i class=""></i>  Successful</a>
                                                </li>

                                            
                                            <li class="nav-item">
                                                <a class="nav-link" id="failed-tab" data-toggle="pill" href="#failed" role="tab" aria-controls="failed" aria-selected="false"><i class=""></i> Failed</a>
                                            </li>
                                            
                                            <li class="nav-item">
                                                <a class="nav-link" id="rejected-tab" data-toggle="pill" href="#rejected" role="tab" aria-controls="rejected" aria-selected="false"><i class=""></i> Rejected</a>
                                            </li>
                                        </ul>
                                        <!--/tabs  -->
                                        <br>
                                    <div class="tab-content" id="pills-tabContent">
                                        <div id="initiated" role="tabpanel" aria-labelledby="initiated-tab" class="tab-pane fade show active">
                                        <div class="table-responsive">
                                        <table id="table" class="display table table-striped table-hover" cellspacing="0" width="100%">
                                            <thead class="thead-default">
                                                <tr>
                                                    <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                    <th>Customer</th>
                                                    <?php endif; ?>
                                                    <th>Contact No</th>
                                                    <th>Group</th>
                                                    <th>Amount[Kes.]</th>
                                                    <th>Ref.</th>
                                                    <th>Paid on</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                <th>Customer</th>
                                                <?php endif; ?>
                                                <th>Contact No</th>
                                                <th>Group</th>
                                                <th>Amount[Kes.]</th>
                                                <th>Ref.</th>
                                                <th>Paid on</th>
                                                <th>Actions</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                <td>
                                                <?php if($payment->customer_client_cust_client_id): ?>
                                                    <?php echo e($payment->ClientPaymentClient->ClientCustomer->cust_name); ?>

                                                <?php elseif($payment->customer_client_batch_id): ?>
                                                    <?php echo e($payment->ClientPaymentBatch->ClientBatchCustomer->cust_name); ?>

                                                <?php elseif($payment->client_b2b_number): ?>
                                                    <?php echo e($payment->ClientPaymentCustomer->cust_name); ?>

                                                <?php endif; ?>
                                                </td>
                                                <?php endif; ?>
                                                <td><?php if($payment->customer_client_cust_client_id): ?>
                                                    254<?php echo e($payment->ClientPaymentClient->cust_client_phone); ?>

                                                    <?php elseif($payment->customer_client_batch_id): ?>
                                                    254<?php echo e($payment->ClientPaymentBatch->client_phone); ?><span class="text-success" title="Batch contact">[B2CBatch]</span>
                                                    <?php elseif($payment->client_b2b_number): ?>
                                                     <?php echo e($payment->client_b2b_number); ?><span class="text-success" title="B2B payment with Remarks: <?php echo e($payment->client_pay_remarks); ?>">[B2B]</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                <?php if($payment->customer_client_cust_client_id): ?>
                                                    <?php if($payment->ClientPaymentClient->ClientClientGroup): ?>
                                                        <?php echo e($payment->ClientPaymentClient->ClientClientGroup->ClientGroupGroup->cust_group_name); ?>

                                                    <?php else: ?>
                                                        N/A
                                                    <?php endif; ?>
                                                <?php elseif($payment->customer_cust_id): ?>
                                                <span title="B2B payment with Remarks: <?php echo e($payment->client_pay_remarks); ?>">[B2B]</span>
                                                <?php elseif($payment->customer_client_batch_id): ?>
                                                    <span title="Batch payment has no group">[Batch]</span>
                                                <?php endif; ?>
                                                    </td>
                                                <td><?php echo e($payment->client_pay_amount); ?></td>
                                                <td><?php echo e($payment->client_pay_ref); ?></td>
                                                <td><?php echo e($payment->created_at); ?></td>
                                                
                                                <td>
                                                <div class="form-button-action" role="group" aria-label="Actions">
                                                    <?php if(Auth::user()->user_type == 'organization_user'): ?>
                                                    <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#myModalEdit-<?php echo e($payment->client_pay_id); ?>" id="show-modal"><i class="fa fa-edit"></i> </button>
                                                    <button  @click="deleteItem('deletepaypath',<?php echo e($payment->client_pay_id); ?>)" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                                <i class="fa fa-trash-alt"></i> 
                                                    </button>
                                                    <?php endif; ?>
                                                </div>
                                                            <!-- edit pay -->
                                                    <div class="modal fade" id="myModalEdit-<?php echo e($payment->client_pay_id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                                        <div class="modal-dialog" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                <h4>Edit Payment for ID# <?php echo e($payment->client_pay_id); ?></h4>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                
                                                                    <div class="modal-body bg-light">
                                                                        
                                                                        <edit_pay_client :data="<?php echo e(json_encode($payment)); ?>"/>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        
                                                                    </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- /end edit pay -->
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                            </table>
                                            </div>
                                            </div>
                                            <div id="successful" role="tabpanel" aria-labelledby="succesful-tab" class="tab-pane fade">

                                        <div class="table-responsive">
                                        <table id="table" class="display table table-striped table-hover" cellspacing="0" width="100%">
                                            <thead class="thead-default">
                                                <tr>
                                                    <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                    <th>Customer</th>
                                                    <?php endif; ?>
                                                    <th>Contact No</th>
                                                    <th>Group</th>
                                                    <th>Amount[Kes.]</th>
                                                    <th>Ref.</th>
                                                    <th>Paid on</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                <th>Customer</th>
                                                <?php endif; ?>
                                                <th>Contact No</th>
                                                <th>Group</th>
                                                <th>Amount[Kes.]</th>
                                                <th>Ref.</th>
                                                <th>Paid on</th>
                                                <th>Actions</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            <?php $__currentLoopData = $successful; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $is_registered = App\Models\bmmodels\CustomerWalletTransaction::where('wallet_trans_ref',$payment->client_pay_ref)->pluck('is_registered');
                                                if($is_registered->count())
                                                {
                                                    if($is_registered[0] == 'Y')
                                                    {
                                                        echo '<tr class="table-default">';
                                                    }
                                                    else 
                                                    {
                                                        echo '<tr class="table-warning">';
                                                    }
                                                }
                                            ?>
                                                <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                <td>
                                                <?php if($payment->customer_client_cust_client_id): ?>
                                                    <?php echo e($payment->ClientPaymentClient['ClientCustomer']['cust_name']); ?>

                                                <?php elseif($payment->customer_client_batch_id): ?>
                                                    <?php echo e($payment->ClientPaymentBatch->ClientBatchCustomer->cust_name); ?>

                                                <?php elseif($payment->client_b2b_number): ?>
                                                    <?php echo e($payment->ClientPaymentCustomer->cust_name); ?>

                                                <?php endif; ?>
                                                </td>
                                                <?php endif; ?>
                                                <td><?php if($payment->customer_client_cust_client_id): ?>
                                                   254<?php echo e($payment['ClientPaymentClient']['cust_client_phone']); ?>

                                                    <?php elseif($payment->customer_client_batch_id): ?>
                                                    254<?php echo e($payment->ClientPaymentBatch->client_phone); ?><span class="text-success" title="Batch contact">[B2CBatch]</span>
                                                    <?php elseif($payment->client_b2b_number): ?>
                                                     <?php echo e($payment->client_b2b_number); ?><span class="text-success" title="B2B payment with Remarks: <?php echo e($payment->client_b2b_number); ?>">[B2B]</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                <?php if($payment->customer_client_cust_client_id): ?>
                                                    <?php if($payment['ClientPaymentClient']['ClientClientGroup']): ?>
                                                        <?php echo e($payment->ClientPaymentClient->ClientClientGroup->ClientGroupGroup->cust_group_name); ?>

                                                    <?php else: ?>
                                                        N/A
                                                    <?php endif; ?>
                                                <?php elseif($payment->customer_cust_id): ?>
                                                <span title="B2B payment with Remarks: <?php echo e($payment->client_pay_remarks); ?>">[B2B]</span>
                                                <?php elseif($payment->customer_client_batch_id): ?>
                                                    <span title="Batch payment has no group">[Batch]</span>
                                                <?php endif; ?>
                                                    </td>
                                                <td><?php echo e($payment->client_pay_amount); ?></td>
                                                <td><?php echo e($payment->client_pay_ref); ?></td>
                                                <td><?php echo e($payment->created_at); ?></td>
                                                <td>
                                                    <button class="btn btn-success btn-sm" type="button" data-toggle="modal" data-target="#view-<?php echo e($payment->client_pay_id); ?>">View</button>
                                                    <!-- view -->
                                                     <div class="modal fade" id="view-<?php echo e($payment->client_pay_id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                                        <div class="modal-dialog" role="document">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                <h4>View Transaction- <?php echo e($payment->client_pay_ref); ?></h4>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                        <span aria-hidden="true">&times;</span>
                                                                    </button>
                                                                </div>
                                                                
                                                                    <div class="modal-body bg-light">
                                                                        <h4><strong>Amount</strong>: <?php echo e($payment->client_pay_amount); ?></h4>
                                                                        <h4><strong>Registered?:</strong>: 
                                                                                    <?php
                                                                                    $is_registered = App\Models\bmmodels\CustomerWalletTransaction::where('wallet_trans_ref',$payment->client_pay_ref)->pluck('is_registered');
                                                                                    if($is_registered->count())
                                                                                    {
                                                                                        if($is_registered[0] == 'Y')
                                                                                        {
                                                                                            echo '<span class="badge badge-success">Yes</span>';
                                                                                        }
                                                                                        else if($is_registered[0] == 'N')
                                                                                        {
                                                                                            echo '<span class="badge badge-danger">No</span>';
                                                                                        }
                                                                                    }
                                                                                    ?>
                                                                        </h4>
                                                                        <h4><strong>Charges</strong>: <?php
                                                                                    $charge = App\Models\bmmodels\CustomerWalletTransaction::where('wallet_trans_ref',$payment->client_pay_ref)->pluck('wallet_trans_charge');
                                                                                    if($charge->count())
                                                                                    {
                                                                                        echo round($charge[0],2);
                                                                                    }
                                                                                    ?>
                                                                        </h4>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        
                                                                    </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- /view -->
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                            </table>
                                            </div>
                                            </div>
                                            <!--  -->
                                            <div id="failed" role="tabpanel" aria-labelledby="failed-tab" class="tab-pane fade">

                                            <div class="table-responsive">
                                                <table id="table" class="display table table-striped table-hover" cellspacing="0" width="100%">
                                                    <thead class="thead-default">
                                                        <tr>
                                                            <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                            <th>Customer</th>
                                                            <?php endif; ?>
                                                            <th>Contact No</th>
                                                            <th>Group</th>
                                                            <th>Amount[Kes.]</th>
                                                            <th>Ref.</th>
                                                            <th>Paid on</th>
                                                            <th>Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tfoot>
                                                        <tr>
                                                        <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                        <th>Customer</th>
                                                        <?php endif; ?>
                                                        <th>Contact No</th>
                                                        <th>Group</th>
                                                        <th>Amount[Kes.]</th>
                                                        <th>Ref.</th>
                                                        <th>Paid on</th>
                                                        <th>Actions</th>
                                                        </tr>
                                                    </tfoot>
                                                    <tbody>
                                                    <?php $__currentLoopData = $failed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                        <td>
                                                        <?php if($payment->customer_client_cust_client_id): ?>
                                                            <?php echo e($payment->ClientPaymentClient->ClientCustomer->cust_name); ?>

                                                        <?php elseif($payment->customer_client_batch_id): ?>
                                                            <?php echo e($payment->ClientPaymentBatch->ClientBatchCustomer->cust_name); ?>

                                                        <?php endif; ?>
                                                        </td>
                                                        <?php endif; ?>
                                                        <td><?php if($payment->customer_client_cust_client_id): ?>
                                                            254<?php echo e($payment->ClientPaymentClient->cust_client_phone); ?>

                                                            <?php elseif($payment->customer_client_batch_id): ?>
                                                            254<?php echo e($payment->ClientPaymentBatch->client_phone); ?><span class="text-success" title="Batch contact">[B2CBatch]</span>
                                                            <?php elseif($payment->client_b2b_number): ?>
                                                            <?php echo e($payment->client_b2b_number); ?><span class="text-success" title="Batch contact">[B2B]</span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                        <?php if($payment->customer_client_cust_client_id): ?>
                                                            <?php if($payment->ClientPaymentClient->ClientClientGroup): ?>
                                                                <?php echo e($payment->ClientPaymentClient->ClientClientGroup->ClientGroupGroup->cust_group_name); ?>

                                                            <?php else: ?>
                                                                N/A
                                                            <?php endif; ?>
                                                        <?php elseif($payment->client_b2b_number): ?>
                                                        <span title="B2B payment with Remarks: <?php echo e($payment->client_pay_remarks); ?>">[B2B]</span>
                                                        <?php elseif($payment->customer_client_batch_id): ?>
                                                            <span title="Batch payment has no group">[Batch]</span>
                                                        <?php endif; ?>
                                                            </td>
                                                        <td><?php echo e($payment->client_pay_amount); ?></td>
                                                        <td><?php echo e($payment->client_pay_ref); ?></td>
                                                        <td><?php echo e($payment->created_at); ?></td>
                                                        <td>
                                                            <button type="button" @click="retryItem('payretry',<?php echo e($payment->client_pay_id); ?>)" id="<?php echo e($payment->client_pay_id); ?>" data-toggle="tooltip"  data-original-title="Reject" name="Reject" class="tester btn btn-warning btn-sm" title="Initiate Refresh"><i class="fas fa-spinner"></i></button>
                                                 
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                    </table>
                                                    </div>
                                            </div>
                                            <!--  -->
                                            <!-- rejected -->
                                            <div id="rejected" role="tabpanel" aria-labelledby="rejected-tab" class="tab-pane fade">

                                            <div class="table-responsive">
                                                <table id="table" class="display table table-striped table-hover" cellspacing="0" width="100%">
                                                    <thead class="thead-default">
                                                        <tr>
                                                            <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                            <th>Customer</th>
                                                            <?php endif; ?>
                                                            <th>Contact No</th>
                                                            <th>Group</th>
                                                            <th>Amount[Kes.]</th>
                                                            <th>Ref.</th>
                                                            <th>Paid on</th>
                                                            <th>Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tfoot>
                                                        <tr>
                                                        <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                        <th>Customer</th>
                                                        <?php endif; ?>
                                                        <th>Contact No</th>
                                                        <th>Group</th>
                                                        <th>Amount[Kes.]</th>
                                                        <th>Ref.</th>
                                                        <th>Paid on</th>
                                                        <th>Actions</th>
                                                        </tr>
                                                    </tfoot>
                                                    <tbody>
                                                    <?php $__currentLoopData = $rejected; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                                        <td>
                                                        <?php if($payment->customer_client_cust_client_id): ?>
                                                            <?php echo e($payment->ClientPaymentClient->ClientCustomer->cust_name); ?>

                                                        <?php elseif($payment->customer_client_batch_id): ?>
                                                            <?php echo e($payment->ClientPaymentBatch->ClientBatchCustomer->cust_name); ?>

                                                        <?php endif; ?>
                                                        </td>
                                                        <?php endif; ?>
                                                        <td><?php if($payment->customer_client_cust_client_id): ?>
                                                            254<?php echo e($payment->ClientPaymentClient->cust_client_phone); ?>

                                                            <?php elseif($payment->customer_client_batch_id): ?>
                                                            254<?php echo e($payment->ClientPaymentBatch->client_phone); ?><span class="text-success" title="Batch contact">[B2CBatch]</span>
                                                            <?php elseif($payment->client_b2b_number): ?>
                                                            <?php echo e($payment->client_b2b_number); ?><span class="text-success" title="Batch contact">[B2B]</span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                        <?php if($payment->customer_client_cust_client_id): ?>
                                                            <?php if($payment->ClientPaymentClient->ClientClientGroup): ?>
                                                                <?php echo e($payment->ClientPaymentClient->ClientClientGroup->ClientGroupGroup->cust_group_name); ?>

                                                            <?php else: ?>
                                                                N/A
                                                            <?php endif; ?>
                                                        <?php elseif($payment->client_b2b_number): ?>
                                                        <span title="B2B payment with Remarks: <?php echo e($payment->client_pay_remarks); ?>">[B2B]</span>
                                                        <?php elseif($payment->customer_client_batch_id): ?>
                                                            <span title="Batch payment has no group">[Batch]</span>
                                                        <?php endif; ?>
                                                            </td>
                                                        <td><?php echo e($payment->client_pay_amount); ?></td>
                                                        <td><?php echo e($payment->client_pay_ref); ?></td>
                                                        <td><?php echo e($payment->created_at); ?></td>
                                                        <td>
                                                            <button type="button" @click="retryItem('payretry',<?php echo e($payment->client_pay_id); ?>)" id="<?php echo e($payment->client_pay_id); ?>" data-toggle="tooltip"  data-original-title="Reject" name="Reject" class="tester btn btn-warning btn-sm" title="Initiate Refresh"><i class="fas fa-spinner"></i></button>
                                                 
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                    </table>
                                                    </div>
                                            </div>
                                            <!--/rejected  -->
                                        </div>
                                        
                                        <!-- pay clients -->
                                        <div class="modal fade" id="payClient" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Pay Contacts</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body bg-light">
                                                            
                                                            <pay_client/>
                                                        </div>
                                                        <div class="modal-footer">
                                                            
                                                        </div>
                                                    </div>
                                            </div>
                                        </div>
                                        <!-- /pay contact -->
                                        <!-- pay Business -->
                                        <div class="modal fade" id="payBusiness" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Pay Business</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body bg-light">
                                                            
                                                            <pay_business>
                                                        </div>
                                                        <div class="modal-footer">
                                                            
                                                        </div>
                                                    </div>
                                            </div>
                                        </div>
                                        <!-- /pay Business -->
                                        
                                         <!-- pay groups -->
                                         <div class="modal fade" id="payGroup" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Pay Group(s)</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    
                                                        <div class="modal-body bg-light">
                                                            
                                                            <pay_group/>
                                                        </div>
                                                        <div class="modal-footer">
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /pay groups -->
                                        <?php if(Auth::user()->user_type == 'organization_user'): ?>
                                            <!-- pay import -->              
                                        <div class="modal fade" id="importClient" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Import Contacts</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('batchimport', Auth::guard('web')->user()->customer_cust_id)); ?>" method="post" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body bg-light">
                                                            <div class="alert alert-info shadow-sm">
                                                                <p class="mb-0">Download <a href="<?php echo e(url('/sample/paymentclients.xlsx')); ?>">sample file</a></p>
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="import-file">Select excel file to import*</label>
                                                                <input name="file" id="import-file" type="file" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-success btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-danger btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /pay import -->
                                        
                                        <?php endif; ?>
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>

        $(document).ready(() => {
            let url = location.href.replace(/\/$/, "");

            if (location.hash) {
                const hash = url.split("#");
                console.log(hash);
                $('#pills-tab a[href="#'+hash[1]+'"]').tab("show");
                url = location.href.replace(/\/#/, "#");
                console.log(url);
                history.replaceState(null, null, url);
                setTimeout(() => {
                    $(window).scrollTop(0);
                }, 0);
            }
        });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dashmobisky/public_html/Accounts/resources/views/bmviews/payments/index.blade.php ENDPATH**/ ?>