@php
if(Auth::guard('web')->check())
{
    $layout = 'layouts.user';
}
elseif(Auth::guard('admin')->check())
{
 $layout = 'layouts.admin';
 }
 elseif(Auth::guard('customer')->check())
 {
 $layout = 'layouts.customer';
 }
@endphp
@extends($layout)
@section('content')
<div id="vue-admin-user">
<!--<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Groups</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route('user-dashboard')}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Groups</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="#" class="btn btn-white btn-border btn-round mr-2">Manage</a>
                            <a @click="newModal" class="btn btn-white btn-round" ><i class="fa fa-plus"></i> Add Group</a>
                        </div>
                    </div>
                </div>
                <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Groups Detail</div>
                                        @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                            <strong>Error! </strong>There were some errors with inputs.
                                            <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                            </ul>
                                            </div>

                                        @endif
                                        @include('layouts.messages')
                                        @if(!$customerGroups->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="admin-users-table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>ID#</th>
                                                    <th>customer group_name</th>
                                                    <th>customer group status(s)</th>
                                                    <th>customer_cust_id</th>
                                                
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>ID#</th>
                                                <th>customer group_name</th>
                                                <th>customer group status(s)</th>
                                                <th>customer_cust_id</th>
                                              
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($customerGroups as $customerGroup)
                                            <tr>
                                            <td>{{ $customerGroup->cust_group_id }}</td>
                                            <td>{{ ucfirst($customerGroup->cust_group_name) }}</td>
                                            <td>{{ ucfirst($customerGroup->cust_group_status) }}</td>
                                            <td>{{ ucfirst($customerGroup->customer_cust_id) }}</td>
                                           
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <a href="{{ url('/groups/show',$customerGroup->cust_group_id)}}"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="View"><i class="far fa-eye"></i> </button>  </a>
                                            <a href="{{ url('/groups/edit',$customerGroup->cust_group_id)}}"> <button class="btn btn-primary btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="fa fa-edit"></i> </button></a>
                                            <button  @click.prevent="deleteItem({{$customerGroup->cust_group_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            </form>
                                            </div>
                                            </td>
                                            </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                      
                                    </div>
                                </div>
                            </div>
                            @endif     
                            </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    </div>
   
    @endsection