@php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
@endphp
@extends($layout)
@section('content')
<div id="vue-admin-user">
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                        <h4 class="page-title text-white">Group Contacts</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Contact Groups</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                        @if(Auth::user()->user_type != 'organization')
                            <button data-toggle="modal" data-target="#group" id="show-modal" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Contact to Group</button>
                        @else
                            <a href="{{route($fdashboard)}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        @endif
                        </div>
                      </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Contact Groupings</div>
                                        <!-- Group clients modal -->
                                        <div class="modal fade" id="group" tabindex="-1" role="dialog" aria-labelledby="topup" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Add contact to group </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <add_client_group></add_client_group>
                                                        </div>
                                                    </div>
                                                </div>
                                        </div>
                                        <!-- end group clients modal -->
                                        @if(!$groupings)
                                        @include('layouts.nodata')
                                        @else
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Group</th>
                                                    <th>Contact</th>
                                                    @if(Auth::guard('web')->check())
                                                    <th>Group Status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                    @endif
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                    <th>Group</th>
                                                    <th>Contact</th>
                                                    @if(Auth::guard('web')->check())
                                                    <th>Group Status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                    @endif
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($groupings as $grouping)
                                            <tr>                                            
                                            <td>{{ $grouping->ClientGroupGroup->cust_group_name }}</td>
                                            <td>{{ $grouping->ClientGroupClient['cust_client_fullname'] }}</td>
                                            
                                            <td>@if($grouping->ClientGroupGroup['cust_group_status'] == 1)
                                                <span class="badge badge-success">Active</span>
                                                @elseif($grouping->ClientGroupGroup['cust_group_status'] == 0)
                                                <span class="badge badge-danger">Inactive</span>
                                                @endif
                                                </td>
                                            <td>
                                            <div class="btn-group form-actions" role="group" aria-label="Actions">
                                            @if(Auth::user()->user_type == 'organization_user')
                                            <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#editGrouping-{{$grouping->client_grp_id}}" id="show-modal"><i class="fas fa-edit"></i> Edit </button>
                                            <button type="submit" data-toggle="tooltip" @click="deleteItem('clientgrppath', {{ $grouping->client_grp_id }} )" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                 <i class="fa fa-trash-alt"></i>
                                            </button>
                                            @endif
                                            </div>
                                            
                                            <!-- Edit Group clients modal -->
                                            <div class="modal fade" id="editGrouping-{{$grouping->client_grp_id}}" tabindex="-1" role="dialog" aria-labelledby="topup" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit grouped contact</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <edit_client_group :cgdata="{{ json_encode($grouping) }}"></edit_client_group>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <!-- end edit group clients modal -->
                                         </td>
                                         
                                            </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                         </div>
                                        @endif

                                        
                                        
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>

            </div>
            </div>
        </div>
    </div>
</div>
    @endsection