@php
if(Auth::guard('organization')->check())
{
    $layout = 'layouts.org';
}
elseif(Auth::guard('web')->check())
{
    $layout = 'layouts.user';
}
@endphp
@extends($layout)
@section('content')

<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>


<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Schedule SMS</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Schedule</a>
                                    </li>
                                </ul>
                        </div></div>
                      
                      
                      
                      
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>


                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="true">
                                   <i class="fas fa-plus"></i> Add Scheduled SMS
                                </button>
                                
                                
                                
                                
                                <ul class="dropdown-menu" role="menu">
                                <li>

                                <a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> To Imports</a>
                                <!--<a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item"><i class="fas fa-file-import"></i> To Import</a>-->
                                  
                                <a href="#" data-toggle="modal" data-target="#contact" id="show-modal" class="dropdown-item"><i class="fa fa-plus"></i> To Contact</a>
                                <a href="#" data-toggle="modal" data-target="#group" id="show-modal" class="dropdown-item" href="#"><i class="fa fa-plus"></i> To Group</a>
                                </li> 
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Schedules</div>
                                        @include('layouts.messages')
                                        <!-- check if exist -->
                                        @if(!$schedules->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Message</th>
                                                <th>Number</th>
                                            
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Message</th>
                                                <th>Number</th>
                                            
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($schedules as $schedule)
                                            <tr>
                                            <td>{{ $schedule->bulk_sms_id }}</td>
                                            <td>{{$schedule->message}}</td>
                                            <td>{{ $schedule->recipients }}</td>
                                           
                                           
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <a href="#" data-target="#edit-{{ $schedule->bulk_sms_id }}" data-toggle="modal" id="show-modal"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="View"><i class="far fa-eye"></i> </button>  </a>
                                            <a href="#" data-target="#view-{{ $schedule->bulk_sms_id }}" data-toggle="modal" id="show-modal"> <button class="btn btn-primary btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="fa fa-edit"></i> </button></a>
                                            <button  @click.prevent="deleteItem('scheduleDeletepath',{{$schedule->bulk_sms_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            
                                            </form>
                                            </div>
                                            </td>
                                            </tr>
                                            
                                            
                                                        
                                            
                                            <!-- edit modal -->
                                            <div class="modal fade" id="edit-{{ $schedule->bulk_sms_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">View Contact </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <contactview_component :scheduledata="{{json_encode($schedule)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                                            <!-- view modal -->
                                            <div class="modal fade" id="view-{{ $schedule->bulk_sms_id  }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Contact </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         
                                                         <contactsedit_component :scheduledata="{{json_encode($schedule)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end view modal -->
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif 
                                    </div>
                                    
                                    
                                     <!-- contact modal -->
                                    <div class="modal fade" id="contact" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Schedule SMS To Contact </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <schedulesms_component />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end contact modal -->
                                            
                                                      <!-- view modal -->
                                            <div class="modal fade" id="group" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Schedule SMS To Group </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         
                                                         <schedulesmsgroup_component />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end view modal -->
                                    
                                    
                                    
                                    
                                    <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Contact </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <contactcreate_component/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                                            <!--  import -->              
                                        <div class="modal fade" id="importClient" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Import SMS Contacts</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="{{ route('scheduleImport')}}" method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body bg-light">
                                                            <div class="alert alert-info shadow-sm">
                                                                <p class="mb-0">Download <a href="{{ url('/sample/Imports.xlsx') }}">sample file</a></p>
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="import-file">Select excel file to import* <div style="color:red;">(Can Only send to ) 
                                                               </div> @foreach ($mycountries as $object)
                                                              {{ $object->rateCountry->name }}
                                                                @endforeach</label>
                                                                <input name="file" id="import-file" type="file" class="form-control">
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="time">Schedule Date:</label>
                                                                <input name="date" type="date" class="form-control" required>
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="time">Schedule Time:</label>
                                                                <input name="time" type="time" class="form-control" required>
                                                            </div>
                                                        
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-success btn-round btn-md"><i class="fa fa-check"></i> Schedule</button>
                                                            <button type="button" class="btn btn-danger btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- / import -->
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    
@endsection

    