<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerWallet extends Model
{
   
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    //
    protected $fillable = [
        'cust_wallet_id',
        'cust_wallet_bal',
        'cust_wallet_account_name',
        'customer_cust_id'
    ];
    protected $primaryKey = 'cust_wallet_id';
    //Wallet<>customer relationship
    public function WalletCustomer()
    {
        return $this->belongsTo(Customer::class,'customer_cust_id','cust_id');
    }
    //Wallet<>wallet transactions relationship
    public function WalletTransactions()
    {
        return $this->hasMany(CustomerWalletTransaction::class,'cust_wallet_cust_wallet_id');
    }
}
