<?php

namespace App\Http\Controllers\FCControllers\Survey;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Exception;
use Log;
use App\Models\fcmodels\Question;
use App\Models\fcmodels\Option;
use App\Models\fcmodels\Survey;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\Language;
use App\Models\fcmodels\Branching;

class MobiQuestionController extends Controller
{
    //
    public function index($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        
        else{
            return abort('401');
        }
        $lang = Language::findOrFail($id);
        $survey = Survey::findOrFail($lang['survey_id']);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $questions = Question::where('survey_id',$survey['id'])->where('language_id',$lang['id'])->get();
        
        return view('fcviews.mobisurvey.question.index',compact('questions','survey','lang','wallet'));
    }

    //Store a newly created resource in storage
    public function store(Request $request)
    {
        $request->validate([
            'number' => 'required',
            'type' => 'required',
            'question' => 'required',
        ]);
        
        $question = new Question();
        $question->number = $request->number;
        $question->type = $request->type;
        $question->survey_id = $request->survey;
        $question->language_id = $request->language;
        $question->question = $request->question;
        $question->branching = $request->branching ?? 'NO';
        
        $question->save();
        if(!empty($request->thebranches))
        {
            
            
            //add branchings
            foreach($request->thebranches as $branch)
            {
                $branching = new Branching();
                $branching->question_id = $question['id'];
                $branching->if = $branch['if'];
                $branching->next = $branch['next'];
                $branching->save();
            }
        }
        //add options
        if(!empty($request->thechoices))
        {
            foreach($request->thechoices as $choice)
            {
                $option = new Option();
                $option->question_id = $question['id'];
                $option->option = $choice['option'];
                $option->response = $choice['response'];
                $option->save();
            }
        }
        
        
    }
    //update
    public function update(Request $request)
    {
        //
        $request->validate([
            'number' => 'required',
            'type' => 'required',
            'question' => 'required',
        ]);
        $question = Question::findOrFail($request->id);
        $question->number = $request->number;
        $question->type = $request->type;
        $question->question = $request->question;
        $question->save();
        
        if(!empty($request->thebranches))
        {
            
            
            //add branchings
            foreach($request->thebranches as $branch)
            {
                $branching = new Branching();
                $branching->question_id = $question['id'];
                $branching->if = $branch['if'];
                $branching->next = $branch['next'];
                $branching->save();
            }
        }
        
        //add options
        if(!empty($request->thechoices))
        {
            foreach($request->thechoices as $choice)
            {
                $option = new Option();
                $option->question_id = $question['id'];
                $option->option = $choice['option'];
                $option->response = $choice['response'];
                $option->save();
            }
        }
    }
    //delete
     //delete
 public function destroy(Request $request,$id)
  {

    //find user details to delete
    $admin = Question::where('id',$id)->get();
    //set delete
 
    $question = Question::findOrFail($id);
    $question->delete();
    //set logging
    $option = Option::where('question_id',$id)->delete();
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Question details: ".$admin." deleted by Admin ID#" .$id;
    
    $adminLog->user_category = "organization";
    $adminLog->user_id = $id; 
    $adminLog->save();
}
}
