<?php

namespace App\Http\Controllers\FCControllers;

use Auth;
use Exception;
use Log;
use App\Models\fcmodels\Question;
use App\Models\fcmodels\Option;
use App\Models\fcmodels\Survey;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\Language;
use App\Models\fcmodels\Response;
Use DB;
use Illuminate\Http\Request;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
class ResponseController extends Controller
{
   public function index($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        
        else{
            return abort('401');
        }
        $survey = Survey::findOrFail($id);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $questions = Question::where('survey_id',$survey['id'])->get();
        
        return view('fcviews.responses.index',compact('questions','survey','wallet'));
    }

    public function responsetoquiz($id)
    {
        //
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
      
        else{
            return abort('401');
        }
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        //get table
        $quizz = Question::findOrFail($id);
        $dbtable = 'participant_'.$ids.'_'.$quizz['survey_id'];
    
        //get responses to this quiz
        $responses = Response::where('question_id',$id)->where('response','!=',NULL)->get();
        return view('fcviews.responses.responsequiz',compact('wallet','responses','dbtable','quizz','id'));
    }
    
    
    
    public function responses_participant($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
       
        else{
            return abort('401');
        }
        $table='participant_'.$ids.'_'.$id;
      
        $checkarray=count(Schema::getColumnListing($table));
         $survey = Survey::findOrFail($id);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        if(!empty($checkarray))
            {
            $tablecolumns1=array_slice(Schema::getColumnListing($table),0,$checkarray-4);
            //get the table columns
            $tablecolumns=array_slice($tablecolumns1,2);
            $participants = DB::select("SELECT * FROM $table");
            
              return view('fcviews.responses_participant.index',compact('id','survey','wallet','participants','tablecolumns'));
             }
             else{
                   return view('fcviews.responses_participant.index',compact('id','survey','wallet'));
             }
          
       
      
      
    }
  
  
    public function quiz($id)
    {
        //
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
      
        else{
            return abort('401');
        }
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        //get table
        $response=Response::where('participant_id',$id)->with('responseQuestion')->first();
        
        $survey_id = $response->responseQuestion->survey_id ?? '';
        //get responses to this quiz
        $responses = Response::where('participant_id',$id)->with('responseQuestion')->get();
    
        //return $responses;
        return view('fcviews.responses_participant.responsequiz',compact('wallet','responses','id'));
    }
}