<?php

namespace App\Http\Controllers\ATControllers;

use App\Http\Controllers\Controller;
Use Maatwebsite\Excel\Facades\Excel;
use App\Models\atmodels\Airtime_contact;
use App\Models\atmodels\Airtime_group;
use App\Models\atmodels\Currency_credit;
use App\Models\bmmodels\CustomerClient;
use App\Models\fcmodels\Contact;
use App\Models\atmodels\Airtime_Contacts_Group_Association;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;
use App\Imports\ATImports\ContactsImport;

use Auth;
use Exception;
use Hash;
use Log;
use DB;
class AirtimeContactController extends Controller
{
    //return contacts view
    public function index()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $shop_id=Auth::user()->shop_id;            
            $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount'); 
            $contacts = Airtime_contact::where('customer_id',$customer_id)->with('contactGroup')->take(10)->get();           
            $groups = Airtime_group::where('customer_id',$customer_id)->get();
           
            return view('atviews.contacts.index', compact('contacts','groups','wallet'));
        }
    }
     //return contacts view
              public function index1(Request $request)
{
    $shop_id = Auth::user()->shop_id;
    $customer_id = Auth::user()->userShopUser['customer_id'];

    Log::info($request->all()); // Debugging

    // Cache wallet amount for 5 minutes
    $wallet = Cache::remember("wallet_{$shop_id}", 300, function () use ($shop_id) {
        return Currency_credit::where('shopid', $shop_id)->pluck('amount');
    });

    // Query contacts
    $query = Airtime_contact::where('customer_id', $customer_id)
        ->select('contact_id', 'fname', 'contact', 'group_id') 
        ->with(['contactGroup:group_id,contact_id']) // Optimize query to avoid N+1
        ->orderBy('contact_id', 'desc');

    // Apply search filter
    $search = $request->input('search');
    if (!empty($search)) {
        $query->where('contact', 'LIKE', "%{$search}%");
    }

    // Paginate results
    $contacts = $query->paginate(10)->appends(['search' => $search]);

    // Cache groups for 5 minutes
    $groups = Cache::remember("groups_{$customer_id}", 300, function () use ($customer_id) {
        return Airtime_group::where('customer_id', $customer_id)->get();
    });

    return view('atviews.contacts.index', compact('contacts', 'groups', 'wallet'));
}


 public function index14s(Request $request)
{
    return response()->json($request->all());
}

     
public function index141(Request $request)
{
    return  $request;
    if (!$request->has('search')) {
        return redirect()->route('contacts.index1'); // Redirect if no search query
    }

    Log::info('Full Request Data:', $request->all());

    $customer_id = Auth::user()->userShopUser['customer_id'];
    $query = Airtime_contact::where('customer_id', $customer_id)
        ->with('contactGroup')
        ->orderBy('contact_id', 'desc');

    $search = $request->input('search');
    if (!empty($search)) {
        Log::info("Search Query: $search");
        $query->where('contact', 'LIKE', "%{$search}%");
    }

    $contacts = $query->paginate(420)->appends(['search' => $search]);
    return view('atviews.contacts.index', compact('contacts'));
}



    
      //return groups
      public function getcontactsgroups1()
      {
          if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
          {
              $shop_id=Auth::user()->shop_id;
              $customer_id=Auth::user()->userShopUser['customer_id'];
              $groups = Airtime_contact::with('groupAssoContacts')->where('customer_id',$customer_id)->get();
              return $groups;    
          }
      }


     //return index1vuedata
      //return groups
    public function getGroups()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $groups = Airtime_contact::with('groupAssoContacts')->where('customer_id',$customer_id)->get();
            return $groups;    
        }









        // if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        // {
        //     $shop_id=Auth::user()->shop_id;
        //     $customer_id=Auth::user()->userShopUser['customer_id'];
        //     $groups = Airtime_group::where('customer_id',$customer_id)->get();
        //     return $groups;
        // }
    }

    //get contact data for edit
    public function getContactData($id){
        $contacts = Airtime_contact::where('contact_id',$id)->get();
        return response()->json($contacts);
    }


  //return groups
  public function getContacts()
  {
      if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
      {
          $shop_id=Auth::user()->shop_id;
          $customer_id=Auth::user()->userShopUser['customer_id'];
          $contacts = Airtime_contact::where('customer_id',$customer_id)->with('contactGroup')->get();  
          return $contacts;
      }
  }

    //return groups
    public function oldGet()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $groups = Airtime_contact::where('customer_id',$customer_id)->get();
            return $groups;
        }
    }
    
    //get all contacts
    
    public function get(){
        $newdata=array();
        if(Auth::user()->user_type == 'organization_user') 
        {
             $shop_id=Auth::user()->shop_id;
             $customer_id=Auth::user()->userShopUser['customer_id'];
             $contacts = Airtime_contact::where('customer_id',$customer_id)->get();
            
            if(Auth::user()->cust_id){
                $c=array();
                 $fcuser_id = Auth::user()->organization_id;
                 $contacts=Contact::where('organization_id',$fcuser_id)->get(['phone AS contact','name AS fname','contact_id'])->toArray();
       
                foreach($contacts as $a){
                    $b['contact']="+254".substr($a['contact'],-9);
                    $b['fname']=$a['fname'];
                    $b['contact_id']=$a['contact_id'];
                    array_push($c,$b);
                
                }
            }
            
            if(Auth::user()->bulk_cust_id){
                $id=Auth::user()->bulk_cust_id;
                $data = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->get(['cust_client_phone AS contact','cust_client_fullname AS fname','cust_client_id AS contact_id'])->toArray();
               
                foreach($data as $a){
                    $mdata['contact']="+254".$a['contact'];
                    $mdata['fname']=$a['fname'];
                    $mdata['contact_id']=$a['contact_id'];
                    array_push($c,$mdata);
                
                }
            }
            
           $newdata=array_merge($contacts,$c);
            
            
           
        }
        else if(Auth::user()->user_type == 'organization'){
            
             $shop_id=Auth::user()->shop_id;
             $customer_id=Auth::user()->userShopUser['customer_id'];
             $contacts = Airtime_contact::where('customer_id',$customer_id)->get();
             
             
        }
        
        return $newdata;
    }

    
   //return Contacts groups
   public function getContactGroups($id)
   {
       $m=array_slice(explode(',',$id),0,-1);
      
       if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
       {
           $shop_id=Auth::user()->shop_id;
           $customer_id=Auth::user()->userShopUser['customer_id'];
           $groups = Airtime_group::wherein('group_id',$m)->get();
          // $groups = Airtime_contact::where('customer_id',$customer_id)->get();
           return $groups;
       }
   }

    //
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        
        $number="";
     
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        
        $no = $request->phone;
       
        //format the number to pick any format
        if((substr($no, 0, 4)=="+254")||(substr($no, 0, 3)=="254")||(substr($no, 0, 2)=="07")||(substr($no, 0, 1)=="7")){
                    
            if(substr($no, 0, 4)=="+254"){
                $number="+254" . substr($no, -9);
            }
            
            elseif(substr($no, 0, 3)=="254"){
                $number="+254" . substr($no, -9);  
            }
            elseif(substr($no, 0, 1)=="0"){
                $number="+254" . substr($no, -9); 
            }
            elseif(substr($no, 0, 1)=="7"){
                $number="+2547" . substr($no, -9); 
            }
        }
        //check duplicate
        $check=Airtime_contact::where('contact',$number)->where('customer_id',$customer_id)->get();
        if($check->count())
        {
            $phones_arr=$check[0]->contact;
        
            return response()->json(["errors"=>["phone"=>["Phone number(s) already added ".json_encode($phones_arr)]]],422);
        }
     Log::info($request);
        $data = new Airtime_contact();
        $data->fname = $request->name;
        $data->contact = $number;
        $data->customer_id = $customer_id;
        $data->group_id = $request->group_id['group_id'];
       // return $data->group_id;
        // if($request->group_id)
        // {
        //     //get group ids into array
        //     $groups = [];
        //     foreach($request->group_id as $group)
        //     {
        //         array_push($groups,(int)$group['group_id']);
        //     }
        //     $data->group_id = json_encode($groups);
        // }
        $data->save();

 Log::info($data->save());

        // foreach ($request->group_id as $item) {
        //     $groupasso = new Airtime_Contacts_Group_Association();
        //    // $lastInsertedId = Airtime_contact::getPdo()->lastInsertId();
        //    // $lastInsertID = DB::table('Airtime_contact')->get();
        //    // dd($lastInsertID);
        //     $groupasso->group_id = $item['group_id'];
        //     $groupasso->contact_id = '15810';
        //     $groupasso->save ();  
       
   



    }

    //import contacts
    public function import(Request $request) 
    {

        if(Auth::user()->user_type == 'organization_user')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort('401');
        }


         request()->validate([
            'file' => 'required|max:2000'
         ],
         [
             'file.required' => 'Please select a file first',
             'file.max' => 'Please select a file with size under 2MBs',
         ]);
        $path = $request->file;
        $extensions = array("xls","xlsx","xlm","xla","xlc","xlt","xlw","csv");

        $result = array($request->file('file')->getClientOriginalExtension());
        
        if(in_array($result[0],$extensions)){
           /// Excel::import(new ContactsImport($customer_id,$request->group), $path);
       Log::info($customer_id);
            Excel::import(new ContactsImport($customer_id), $path);
       
            return redirect()->back()
            ->with('success','Contacts Imported Succesfully.'); 
        }
        else{
           return redirect()->back()->with('failure', 'Please select excel file!');
        }
    }

  
    //edit grp
    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        //get group ids into array
        $groups = [];
        // return $request->group_id; 
        foreach($request->group_names as $group)
         {
           array_push($groups,(int)$group['group_id']);
         }
        
        $data = Airtime_contact::findOrFail($request->contact_id);
        $data->fname = $request->name;
        $data->contact = $request->phone;
       // $data->customer_id = $customer_id;
        $data->group_id = json_encode($groups);
        
        $data->save ();
    }

    //delete group
    public function destroy($id)
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_contact::findOrFail($id);
        $data->delete();
        return redirect()->back()->with('success', 'Deleted succesfully');
    }
    //delete all contacts
    public function destroyAllContacts()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_contact::where('customer_id',$customer_id)->delete();
        return redirect()->back()->with('success', 'Deleted succesfully');
        
    }
    //delete selected
    public function destroySelectedContacts(Request $request)
    {
        $id = $request->contact;
      
        if(empty($id))
        {
            return redirect()->back()->with('failure', 'Select atleast one contact');
        }
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_contact::where('customer_id',$customer_id)->whereIn('contact_id',$id)->delete();
        return redirect()->back()->with('success', 'Deleted succesfully');
    }

    //deleteselectedcontact
    public function delselectedContacts($id){
        $contactsids=explode(',',$id);
        
        if(empty($contactsids))
        {
            return redirect()->back()->with('failure', 'Select atleast one contact');
        }
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_contact::where('customer_id',$customer_id)->whereIn('contact_id',$contactsids)->delete();
        $status="";
        if($data){
            return $status="success";
        }
        else{
            $status="failed";   
        }
        return $status;

    }
}
