@php
$layout='';
if(Auth::check())
{
    $layout = 'fcviews.layouts.org';
}

@endphp
@extends($layout)
@section('content')

<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Questions for survey <small>{{ $survey['name'] }}</small></h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Questions</a>
                                    </li>
                                </ul>
                        </div></div>
                      
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round" type="button" data-target="#add" data-toggle="modal" id="show-modal">
                                   <i class="fas fa-plus"></i> Create Question
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Questions Details</div>
                                        <!-- check if exist -->
                                            @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                <strong>Error! </strong>There were some errors with inputs.
                                                <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                                @endforeach
                                                </ul>
                                                </div>
                                            @endif
                                        @include('layouts.messages')
                                        @if(!$questions->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th>Number</th>
                                                <th>Question</th>
                                                <th>Type</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                                <th>Number</th>
                                                <th>Question</th>
                                                <th>Type</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($questions as $question)
                                            <tr>
                                            <td>{{ $question->number }}</td>
                                            <td>{{ ucfirst($question->question) }}</td>   
                                            <td>{{ $question->type }}</td>
                                            
                                            <td>
                                                <div class="form-button-action" role="group" aria-label="Actions">
                                                <a href="{{ route('options',$question['id']) }}" > <button class="btn btn-success btn-sm" data-original-title="Options"><i class="fa fa-eye"></i> Options </button></a>

                                <a href="#" data-target="#edit-{{ $question->id }}" data-toggle="modal" id="show-modal"> <button class="btn btn-primary btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="fa fa-edit"></i> </button></a>

                                                          <button  @click.prevent="deleteItem('questionDeletepath',{{$question->id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                            <i class="fa fa-trash-alt"></i> 
                                                    </button>
                                                </div>
                                            </td>
                                            </tr>
                                            <!-- edit modal -->
                                            <div class="modal fade" id="edit-{{ $question->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Question </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <edit-question :data="{{json_encode($question)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                    <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Question </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                @php 
                                                    $survey = ['survey' => $survey['id'], 'language' => $lang['id'] ];
                                                @endphp
                                                    <create-question :data="{{ json_encode($survey) }}"></create-question>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection