@extends('fcviews.layouts.org')
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Department</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Departments</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <a href="#" data-target="#add" data-toggle="modal" id="show-modal" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Departments</a>
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Department Details</div>
                                        <!-- check if exist -->
                                        @if(!$departments->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Name</th>
                                                <th class="text-right" style="width: 10%">Action</th>
                                            </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>ID#</th>
                                                <th>Name</th>
                                                <th class="text-right" style="width: 10%">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($departments as $department)
                                            <tr>
                                            <td>{{ $department->department_id }}</td>
                                            <td>{{ ucfirst($department->name) }}</td>
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                             <a href="#" data-target="#view-{{ $department->department_id }}" data-toggle="modal" id="show-modal"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="View"><i class="fa fa-eye"></i> </button></a>
                                            
                                            <a href="#" data-target="#edit-{{ $department->department_id }}" data-toggle="modal" id="show-modal"> <button class="btn btn-primary btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="far fa-edit"></i> </button>  </a>
                                           
                                            <button type="submit" @click.prevent="deleteItem('departDeletepath',{{$department->department_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            
                                            </form>
                                            </div>
                                            </td>
                                            </tr>
                                            <!-- edit modal -->
                                            <div class="modal fade" id="edit-{{ $department->department_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Department </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         <departmentedit_component :departmentdata="{{json_encode($department)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                                            <!-- view modal -->
                                            <div class="modal fade" id="view-{{ $department->department_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">View Department </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         <departmentview_component :departmentdata="{{json_encode($department)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end view modal -->
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                    <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Department </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <departmentcreate_component/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    @endsection