<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessNumber extends Model
{
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    //
    protected $table ='business_number';
    protected $fillable = [
        'business_number_id',
        'business_number',
        'account_name',
        'tariff_id',
        'business_customer_id',
        'business_number_status'
    ];
    protected $primaryKey = 'business_number_id';
    //customer<> businessnumber relationshiop
    public function Customer()
    {
        return $this->belongsTo(Customer::class, 'business_customer_id','cust_id');
    }
    //b2btariff<> businessnumber relationshiop
    public function B2BTariff()
    {
        return $this->belongsTo(B2BTariff::class,'tariff_id','tariff_id');
    }
    
}