<?php

namespace App\Models\bmmodels;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Notifications\AdminResetPasswordNotification;
use Illuminate\Database\Eloquent\SoftDeletes;

class AdminUser extends Authenticatable
{
    use Notifiable;
    use SoftDeletes;
    protected $connection = 'mysql_bmp';

    protected $guard = 'admin';
    protected $primaryKey = 'admin_id';
    //
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new AdminResetPasswordNotification($token));
    }
    protected $fillable = [
        'admin_id',
        'admin_surname',
        'admin_othername',
        'admin_username',
        'password',
        'admin_status',
        'role_id'
    ];
    public $timestamps = false;
    protected $hidden = [
        'password',
    ];
    
}
