<?php

namespace App\Http\Controllers\FCControllers;

use App\Models\fcmodels\Survey;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Organization;
use App\Models\fcmodels\Organizationshortcode;
use Illuminate\Http\Request;
use Auth;

class SurveyController extends Controller
{
    //return survey view
    public function index()
    {
            if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $surveys = Survey::where('organization_id',$id)->get();
        return view('fcviews.survey.index', compact('surveys','wallet'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        $type='';
        
          if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            $type='organization';
        }
        else{
            return abort('401');
        }
        $survey = new Survey();
        $survey->name = $request->name;
        $survey->shortcode =  $request->shortcode_id['shortcode'];   
        $survey->organization_id = $id;
        $survey->participant_preloaded = $request->participant_preloaded;
        $survey->save();
        //log
       
        $surveylog = new AuditLog();
        $surveylog->audit_module = $type;
        $surveylog->audit_activity = "Survey of name: ".$request->name." created by ".$type." ID# " .$id;
        
        $surveylog->user_category = $type;
        $surveylog->user_id = $id; 
        $surveylog->save();
        
        return 'Saved';
    }

    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        
        $type='';
        $id='';
        
          if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            $type='organization';
        }
        else{
            return abort('401');
        }
        
        $surveydets = Survey::findOrFail($request->id);
        $survey = Survey::findOrFail($request->id);
        $survey->name = $request->name;
        $survey->shortcode = $request->shortcode;
        $survey->status = $request->status;
        $survey->save();
        //log
        $surveylog = new AuditLog();
        $surveylog->audit_module = $type;
        $surveylog->audit_activity = "Survey of details: ".$surveydets." updated to ".$survey." by ".$type." ID# " .$id;
        
        $surveylog->user_category = $type;
        $surveylog->user_id = $id; 
        $surveylog->save();
        
        return 'Saved';
    }

    
    public function destroy($iid)
    {
        $type='';
        $id='';
        
          if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            $type='organization';
        }
        else{
            return abort('401');
        }
        $surveydets = Survey::findOrFail($iid);
        $survey = Survey::findOrFail($iid);
        $survey->delete();
        //log
        $surveylog = new AuditLog();
        $surveylog->audit_module = $type;
        $surveylog->audit_activity = "Survey of details: ".$surveydets." deleted by ".$type." ID# " .$id;
        
        $surveylog->user_category = $type;
        $surveylog->user_id = $id; 
        $surveylog->save();
        
        return 'Deleted';
    }
    public function getHelp($id){
        return "hello ".$id;
    }
       //get getShortcode
    public function getShortcode()
    {
        $type='';
        $id='';
        
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            $type='organization';
        }
        else{
            return abort('401');
        }
            $Shortcodes = Organizationshortcode::where('organization_id',$id)->get();
            return $Shortcodes;
    }
    
    
}
