<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use Auth;
use Exception;
use Log;
use App\Models\fcmodels\Question;
use App\Models\fcmodels\Option;
use App\Models\fcmodels\Survey;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\Language;
use App\Models\fcmodels\AuditLog;

class LanguageController extends Controller
{
    //
    public function index($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else if(Auth::guard('web')->check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->userOrg->api_account;
        }
        else{
            return abort('401');
        }
        $survey = Survey::findOrFail($id);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $languages = Language::where('survey_id',$survey['id'])->get();
        
        return view('fcviews.language.index',compact('languages','survey','wallet'));
    }
    //
    public function store(Request $request)
    {
        //
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
            $type = 'Organization';
        }
       
        else{
            return abort('401');
        }
        $request->validate([
            'language' => 'required',
            'cue' => 'required',
        ]);
             
        $data = new Language();
        $data->cue = $request->cue;
        $data->language = $request->language;
              // return $request;
        $data->save ();
        //log
        $adminLog = new AuditLog();
        $adminLog->audit_module = $type;
        $adminLog->audit_activity = $type." added a language " .$data;
        $adminLog->user_category = $type;
        $adminLog->user_id = $ids;
        $adminLog->save();
        
        return response()->json($data);
    }
    
    
    /**
     * updatelanguage the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     
     
    
    public function updatelanguage(Request $request)
    {

      //  try
        { 
            request()->validate([
                'cue'=> 'required',
                 'language'=> 'required',
           
            ]);
          //  return $id;
        //current customer details
        $id=$request->id;
       
        $customerdets = Language::where('id',$id)->get();
        //updateGroup
        $data = Language::findOrFail($id);
      
        $data->cue = $request->get('cue');
        $data->language = $request->get('language');
        $data->save();

        // log data
        $customerLog = new AuditLog();
        $customerLog->audit_module = "Customer";
        $customerLog->audit_activity = "Customer details ";
        
        $customerLog->user_category = "Admin";
        $customerLog->user_id = 1;
        
        $customerLog->save();
        $data->save();

          return redirect()->back()
            ->with('success','Group Edited Succesfully.'); 
            
        }
      //  catch (Exception $exception)
       // {
          //  return back()->withInput()
            //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
      //  }
    }


 //delete
 public function deleteLanguage(Request $request,$id)
  {

    //find user details to delete
    $admin = Language::where('id',$id)->get();
    //set delete
    $deleteDepartment = Language::find($id);
    $deleteDepartment->delete();
    //set logging
   
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Language of details: ".$admin." deleted by Admin ID#" .$id;
    
    $adminLog->user_category = "organization";
    $adminLog->user_id = $id; 
    $adminLog->save();
}    
        
    
}
