<?php

namespace App\Http\Controllers\BundlesControllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Hash;
use App\Models\atmodels\Shop;
use App\Models\bundles\TailMessage; //groups
use App\Models\atmodels\User;
use App\Models\atmodels\Logs;
use App\Models\atmodels\DataBundlesCredits;
use App\Models\fcmodels\Currency_Expenditure;
use Auth;
use Log;

class TailMessageController extends Controller
{
    //return Airtime_customer view
   public function index()
   {

       if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
       {
        $shop_id=Auth::user()->shop_id;
        $tailmessages=Shop::where('ShopID',$shop_id)->get();
        $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount'); 
       return view('bundleviews.tailmessage.index', compact('tailmessages','datawallet'));
       }
       else{
           return abort(401);
       }
   }


//store
public function storeTailMessage(Request $request)
{
  
     if(Auth::check())
    {
        $id = Auth::user()->organization_id;
        $api_account = Auth::user()->api_account;
    }
    else{
        return abort('401');
    } 
    $user = TailMessage::where('ShopID', '=', $api_account)->first();
    // if ($user) {
    //     $tailmessages='Data already exist';
    //     $shop_id=Auth::user()->shop_id;
    //     $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount'); 
    //     return view('bundleviews.tailmessage.index', compact('tailmessages','datawallet'));
    //    return response()->json($data='Data already exist');
    // }
    $request->validate([
       'tail_messages' => 'required',     
            ]);
     
         

    $data = new TailMessage();
    $data->ShopID = $api_account;
    $data->tail_messages = $request->tail_messages;
    $data->save ();   
    return response()->json($data);
}


//edit grp
public function updateTailMessage(Request $request)
{
    $request->validate([
        'tail_messages' => 'required',
    ]);
    if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
    {
        $shop_id=Auth::user()->shop_id;
        $customer_id=Auth::user()->userShopUser['customer_id'];
    }
    else{
        return abort(401);
    }
    
   // $data = Shop::findOrFail($request->ShopID);
   $data = Shop::findOrFail($request->ShopID);
     $data->tail_message = $request->tail_messages;

    $data->save ();


    $activitylog = new Logs();
    $activitylog->ShopID = $shop_id;
    $activitylog->audit_module = Auth::user()->user_type;
    
    $activitylog->user_id = $customer_id;
    $activitylog->activity_log = 'Updated Activity Log';
    $activitylog->current_messages= $request->previous_messages;
    $activitylog->previous_messages = $request->previous_messages;

    $activitylog->save ();  
    return response()->json($data);
}

 //delete
 public function destroy($id)
  {
  // Log::info($id);
    //find user details to delete
   // $admin = TailMessage::where('data_tail_messages_id',$id)->get();
    //set delete
    $deleteAirtimecustomer = TailMessage::find($id);
    $deleteAirtimecustomer->delete();
    return redirect()
    ->back()
    ->withInput()
    ->with('success', 'Record Deleted');
}

}
