<?php

namespace App\Http\Controllers\ATControllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Hash;
use App\Models\atmodels\Airtime_customer;
use App\Models\atmodels\Airtime_contact; //contatcs
use App\Models\atmodels\Airtime_sending_record; //expenditure
use App\Models\atmodels\Currency_credit; //balance
use App\Models\atmodels\CreditTopup; //topups
use App\Models\atmodels\Airtime_group; //groups
use App\Models\atmodels\User;
class AirtimeUserController extends Controller
{
    public function dashboard()
    {
        //
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $groups=Airtime_group::where('customer_id',$customer_id)->get();
            $topups=CreditTopup::where('shop_id',$shop_id)->sum('credit_amount');
            $balance=Currency_credit::where('shopid',$shop_id)->pluck('amount'); 
            $expenditure=Airtime_sending_record::where('customer_id',$customer_id)->sum('airtime_sent');
            $contacts = Airtime_contact::where('customer_id',$customer_id)->with('contactGroup')->get();

            //recent topups
            $expenditure_recent=Airtime_sending_record::where('customer_id',$customer_id)->latest('date_sent')->take(2)->get();
            //recent my account tpups
            $topups_recent=CreditTopup::where('shop_id',$shop_id)->latest('topup_time')->take(2)->get();
            
              $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');   
            
              return view('atviews.user-dashboard',compact('wallet','contacts','expenditure','balance','topups','groups','expenditure_recent','topups_recent'));
        }
        else{
            return abort('401');
        }
      
    }

   //return Airtime_customer view
   public function index()
   {

       if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
       {
      $usersd = Auth::user()->user_type;
           $shop_id=Auth::user()->shop_id;
         
           $customer_id=Auth::user()->userShopUser['customer_id'];
           $company = Airtime_customer::where('customer_id',$customer_id)->pluck("company");
           $userShopCustomer= Auth::user()->userShopCustomer['Name'];
           $airtimecustomeruser = Airtime_customer::where('company',$userShopCustomer)->get();
      
           return view('atviews.airtimeuser.index',compact('airtimecustomeruser'));
       }
       else{
           return abort(401);
       }
   }


//store
public function storeCustomerUser(Request $request)
{
  
     if(Auth::check())
    {
        $id = Auth::user()->organization_id;
        $api_account = Auth::user()->api_account;
    }
    else{
        return abort('401');
    } 
    $request->validate([
    
        'fname' => 'required',

        'fname' => 'required|min:3|max:50',
        'email' => 'email',
        'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
        'password_confirmation' => 'min:6'      
            ]);
        
    $userShopCustomer= Auth::user()->userShopCustomer['Name'];
    
    $data = new Airtime_customer();
    $data->fname = $request->fname;
    $data->lname = $request->lname;
    $data->username = $request->username;
    $data->pwd_xdm_ps = Hash::make($request->password);
    $data->phone = $request->phone;
    $data->email = $request->email;
    $data->user_type = 'normal';
    $data->status = 'Active';
    $data->company =$userShopCustomer;
    
    $data->save ();

    
    $userdata = new User();
    $userdata->username = $request->username;
    $userdata->password = Hash::make($request->password);
    $userdata->shop_id = Auth::user()->shop_id;
    $userdata->user_type = 'organization_user';
    $userdata->email = $request->email;
    $userdata->remember_token = '';
    
    $userdata->save ();

    //log
    // $adminLog = new AuditLog();
    // $adminLog->audit_module = "Organization";
    // $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .$id;
   
    // $adminLog->user_category = "Admin";
    // $adminLog->user_id = $id;
    // ;
    // $adminLog->save();
    
    return response()->json($data);


}


//edit grp
public function updateCustomerUser(Request $request)
{
  
    $request->validate([
        'fname' => 'required',
    ]);
    if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
    {
        $shop_id=Auth::user()->shop_id;
        $customer_id=Auth::user()->userShopUser['customer_id'];
    }
    else{
        return abort(401);
    }

    $data = Airtime_customer::findOrFail($request->customer_id);
    $data->fname = $request->fname;
    $data->lname = $request->lname;
    $data->username = $request->username;
    $data->pwd_xdm_ps =  Hash::make($request->password);
    $data->phone = $request->phone;
    $data->email = $request->email;
    $data->user_type = 'normal';
    $data->status = 'Active';
    $data->company = Auth::user()->user_type;
   
    $data->save ();
}


//Update Customer User Password
public function updateCustomerUserPassword(Request $request)
{
  
    $request->validate([
        'fname' => 'required',
    ]);
    if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
    {
        $shop_id=Auth::user()->shop_id;
        $customer_id=Auth::user()->userShopUser['customer_id'];
    }
    else{
        return abort(401);
    }

    $data = Airtime_customer::findOrFail($request->customer_id);
    $data = Airtime_customer::findOrFail($request->customer_id);
    $data->password =  Hash::make($request->password);

    $data->save ();
}





 //delete
 public function destroy(Request $request,$id)
  {

    //find user details to delete
    $admin = Airtime_customer::where('customer_id',$id)->get();
    //set delete
    $deleteAirtimecustomer = Airtime_customer::find($id);
    $deleteAirtimecustomer->delete();
    //set logging
   
    // $adminLog = new AuditLog();
    // $adminLog->audit_module = "Organization";
    // $adminLog->audit_activity = "Organization of details: ".$admin." deleted by Admin ID#" .$id;
    
    // $adminLog->user_category = "organization";
    // $adminLog->user_id = $id; 
    // $adminLog->save();
}

//api customer
public function storeCustomer(Request $request)
{
   
    return response()->json($request);
     
    $userdata = new User();
    $userdata->username = $request->username;
    $userdata->password = Hash::make($request->password);
    $userdata->shop_id = $request->shop_id;
    $userdata->user_type = 'organization';
    $userdata->email = $request->email;
    
    $userdata->save ();    

}

}
