@extends('layouts.org')

@section('content')
<div id="vue-admin-user">
    <div class="main-panel">
        <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                                <h4 class="page-title text-white">Survey Reports  for {{ $survey['name']}}</h4>
                                <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="#">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                    </div>
                </div>


                <div class="page-category">
                    <div class="page-inner mt--5">
                     <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-body"> 
                                            @include ('partials.filter-sentsms')
                                            <div class="card-title pull-left">Closed Questions statistics</div>

                                            <div class="text-right mb-3 border-bottom pb-1">
                                                
                                                <!-- <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-sentsms">
                                                    <i class="fas fa-filter"></i> Filter
                                                </a> -->
                                            </div>
                                        </div>
                                        <div class="row">
                                        @php 
                                            $i=0;
                                        @endphp
                                        @foreach($questions as $question)
                                        @php
                                            $foo = ++$i;
                                        @endphp
                                        
                                            <div class="col-md-4">
                                                <div class="card-category">Question:{{$question->number}} {{$question->questionLang->language}}</div>
                                                <div id="fliggel" class="d-flex flex-wrap justify-content-around pb-2 pt-4">
                                                    <canvas id="chart{{$question->id}}"></canvas>
                                                    <input type="hidden" value="{{$question->id}}" name="data" data-id="{{$question->id}}" id="data-{{$question->id}}">
                                                </div>
                                            </div>
                                        @endforeach    
                                        </div>
                                    </div>
                                </div>
                            </div>	    
                        </div>
                    
                    
                     <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">

                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="card-category"></div>
                                                <div class="card-title"> Closed Questions statistics
</div>
                                                <div class="d-flex flex-wrap justify-content-around pb-2 pt-4">
                                                    <canvas id="multipleBarChart"></canvas>

                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="card-category">  </div>
                                                <div class="card-title">Survey statistics</div>

                                                @include ('partials.filter-requestivr')
                                                <div class="row py-3">
                                                    <div class="col-md-4 d-flex flex-column justify-content-around">

                                                        <div>

                        <h6 class="fw-bold">
                                  <a href="{{route('allparticipants', $id)}}     ">   
							<span class="link-collapse">Total  No. </span>   
							</a>  {{ $complete+$incomplete+$participantsnotparticipated }}</h6>
                                                         
                          <h6 class="fw-bold"> 
                        <a href="{{route('completedparticipants', $id)}}">   
							<span class="link-collapse"> Completed No.  </span>   
							</a> 
                                                            
                                                            {{ $complete }}</h6>

                          <h6 class="fw-bold">
                              
                             <a href="{{route('partiallycompletedparticipants', $id)}}">   
							<span class="link-collapse">  Partial No.  </span>   
							</a>   
                              
                                {{ $incomplete }}</h6>



                       


                         <h6 class="fw-bold">
                             
                            <a href="{{route('participantsnotparticipated', $id)}}">   
							<span class="link-collapse">   Not Participated.  </span>   
							</a>     
                             
                              {{ $participantsnotparticipated }}</h6>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <div style="width:80%;">

                                                            <div id="chart">

                                                            {!! $chart1->container() !!}
                                                            </div>
                    
                                </div>
                            </div>	
                        </div>
                </div>





                </div>
            </div>
        </div  
                
            </div>
        </div>
    </div>
</div>
<script src="{{ asset('js/jquery.min.js')}}"></script>
@foreach($questions as $question)
<script type="text/javascript">
$(document).ready(function() {
    // var progress = document.getElementById('animationProgress');
    // $('#fliggel').on('load', function() {
        let qid = $('#data').val();
        $.ajax({
           url: '/getClosedQuiz/'+<?php echo $question->id; ?>,
            dataType: 'json',
            type: "GET",
            success: function (data) {
            var barChart = document.getElementById('<?php echo 'chart'.$question->id; ?>').getContext('2d');
            var complex = data;
            console.log(complex.options);
            var myBarChart = new Chart(barChart, {
                type: 'bar',
                data: {
                    labels: complex.options,
                    datasets : [{
                        label: "Responses per option",
                        backgroundColor: '#fdaf4b',
                        borderColor: '#f2f2f2',
                        data: complex.responses,
                    }],
                },
                options: {
                    responsive: true, 
                    maintainAspectRatio: false,
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:true
                            }
                        }]
                    },
                }

            });
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
    // });
});
</script>
@endforeach


@endsection