@php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'bundleviews.layouts.customer';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bundleviews.layouts.user';
}
@endphp
@extends($layout)
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Tail Message</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Tail Message</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            @if(Auth::user()->user_type == 'organization_user')
                            {{--    <a href="#" data-target="#addTailMessage" data-toggle="modal" id="show-modal" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Tail Message</a>
                                --}}  @endif
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Tail Message Details</div>
                                        <!-- check if exist -->
                             
            @if ($errors->any())
                                        <div class="alert alert-danger alert-dismissible" role="alert">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                        <strong>Error! </strong>There were some errors with inputs.
                                        <ul>
                                        @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                        @endforeach
                                        </ul>
                                        </div>

                                        @endif
                                        @include('layouts.messages')
                                        @if(!$tailmessages->count())
                                        @include('layouts.nodata')
                                        @else



                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                  
                                                <th>Tail Message</th>
                             
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                   
                                                <th>Tail Message</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($tailmessages as $tailmessage)
                                            <tr>
                                          
                                            <td>{{ $tailmessage->tail_message }}</td>
 
                                            <td>
                                                <div class="form-button-action" role="tailmessage" aria-label="Actions">
                                                <a href="#" data-target="#edit-{{ $tailmessage->ShopID }}" data-toggle="modal" id="show-modal"> <button class="btn btn-info btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="far fa-edit"></i> </button>  </a>
{{-- 
<a  class="btn btn-danger btn-sm" title="delete" href="{{route('tailmessage.delete',$tailmessage->ShopID)}}"><i class="fa fa-trash-alt"></i> Delete</a>
--}}                                           


                                           
                                                
                                                </form>
                                                </div>
                                            </td>
                                            </tr>
                                            <!-- edit modal -->
                                            <div class="modal fade" id="edit-{{ $tailmessage->ShopID }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Tail Message </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         <tailmessageedit_component :tailmessagedata="{{json_encode($tailmessage)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                                            <!-- view modal -->
                                            <div class="modal fade" id="view-{{ $tailmessage->ShopID }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Tail Message </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         <tailmessageedit_component :tailmessagedata="{{json_encode($tailmessage)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end view modal -->
                                            @endforeach
                                            </tbody>
                                        </table>
                                       
                                        @endif
                                    </div>
                                    <!-- Create modal -->
                                    <div class="modal fade" id="addTailMessage" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Tail Message </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <tailmessagecreate_component/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    @endsection