@php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'atviews.layouts.customer';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'atviews.layouts.user';
}
@endphp
@extends($layout)

@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Detailed History Summary</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Detailed History Summary</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <!--<a href="#" data-target="#add" data-toggle="modal" id="show-modal" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Group</a>-->
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                        <div class="col-md-12">
                            <div class="card full-height">  
                                <div class="card-body">  
                                    @include ('atviews.partials.filter-detailedsummary')
                                    
                                    <div class="card-title pull-left">Detailed History Summary</div>
                                        <a class="btn btn-success btn-border btn-round btn-sm pull-right" data-toggle="collapse" data-target="#filter-panel">
                                            <i class="fas fa-filter"></i> Filter
                                        </a>
                
                                        <!-- check if exist -->
                                        @if(!$history->count())
                                        @include('layouts.nodata')
                                        @else
                                            <div class="table-responsive">
                                            <div class="text-right mb-3 border-bottom pb-1"></div>
                                            <form id="groups-filter-form" class="form" action="{{ route('at.history.excel', request()->all()) }}" role="form">
                                                <a href="{{ route('at.history.excel', request()->all()) }}"class="btn btn-sm btn-border btn-round btn-success">Excel</a>
                                                <a href="{{ route('at.history.pdf',  request()->all()) }}" class="btn btn-sm btn-border btn-round btn-danger">PDF</a>
                                            </form>
            


                                                <table  id="table" class="display table table-striped table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>RequestID</th>
                                                            <th>Date</th>
                                                            <th>Airtime Sent</th>
                                                            <th>Recipient</th>
                                                            <th>Name</th>
                                                            <th>Group</th>
                                                            <th>Status</th>
                                                        </tr>
                                                    </thead>
                                                        <tfoot>
                                                            <tr>
                                                                <th>RequestID</th>
                                                                <th>Date</th>
                                                                <th>Airtime Sent</th>
                                                                <th>Recipient</th>
                                                                <th>Name</th>
                                                                <th>Group</th>
                                                                <th>Status</th>
                                                            </tr>
                                                        </tfoot>
                                                    <tbody>
                                                        @foreach($history as $myhistory)
                                                            <tr>
                                                                <td>{{ $myhistory->requestid }}</td>
                                                                <td>{{ $myhistory->date_sent }}</td>
                                                                <td>{{ $myhistory->airtime_sent }}</td>
                                                                <td>{{ $myhistory->recipient }}</td>
                                                                <td>
                                                                    @php
                                                                        $phone=$myhistory->recipient;
                                                                        $contact = App\Models\atmodels\Airtime_contact::where('customer_id',$customer_id)->where('contact','LIKE',"%".$phone."%")->with('contactGroup')->first();
                                                                        
                                                                    @endphp
                                                                    @if(!empty($contact))

                                                                    {{ $contact->fname }}
                                                                    @endif
                                                                </td>
                                                                <td>    @if(!empty($contact))
                                                                @if($contact->contactGroup)
                                                                        {{ $contact->contactGroup->name }}
                                                                    @endif
                                                                    @endif
                                                                </td>
                                                                <td>{{ $myhistory->status }}</td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script src="{{ asset('js/app.js') }}" type="text/js"></script>
        </div>
    @endsection