@php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
@endphp
@extends($layout)
@section('content')

<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>
<div class="main-panel">
    <div class="content"> 
    <div id="vue-admin-user">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Contact #{{$id}}</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>                                       
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Contact</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                        @if(Auth::user()->user_type != 'organization')
                        <a href="{{route('customers.index')}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="true">
                                   <i class="fas fa-plus"></i> Add Contacts
                                </button>
                                <ul class="dropdown-menu" role="menu" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -117px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <li>
                                <a href="#" data-toggle="modal" data-target="#myModal" id="show-modal" class="dropdown-item"><i class="fa fa-plus"></i> Add Contact</a>
                                <a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item" href="#"><i class="fas fa-file-import"></i> Import Contacts</a>
                                </li>
                                </ul>
                            </div>
                            @else
                             <a href="{{route($fdashboard)}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                           
                            @endif
                       
                       
                        </div>
                    </div>
                </div>
                <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                
                                    <div class="card-body">
                                    @include ('bmviews.partials.filter-contacts')
                                    <div class="text-right mb-3 border-bottom pb-3">
                                    <div class="card-title pull-left">Contacts</div>
                                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                                            <i class="fas fa-filter"></i> Filter
                                        </a>
                                    </div>
                                        @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                            <strong>Error! </strong>There were some errors with inputs.
                                            <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                            </ul>
                                            </div>

                                        @endif
                                        @include('layouts.messages')
                                        @if(!$CustomerClients->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                <th>Name</th>
                                                <th>ID No.</th>
                                                <th>Phone</th>
                                                <th>Created By</th>
                                                <th>Status</th> 
                                                
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>Name</th>
                                                <th>ID No.</th>
                                                <th>Phone</th>
                                                <th>Created By</th>
                                                <th>Status</th> 
                                       
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($CustomerClients as $CustomerClient)
                                            <tr>
                                            <td>{{ $CustomerClient->cust_client_fullname }}</td>
                                            <td>{{ $CustomerClient->cust_client_idno }}</td>
                                            <td>+254 {{ $CustomerClient->cust_client_phone }}</td>
                                            <td> {{ $CustomerClient->created_by }}</td>
                                            <td>@if ($CustomerClient->cust_client_status == 1)
                                            <span class="badge badge-success">Active</span>
                                            @elseif ($CustomerClient->cust_client_status == 0)
                                            <span class="badge badge-danger">Inactive</span>
                                            @endif
                                            </td>
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <a href="{{ route('client.show',$CustomerClient->cust_client_id)}}"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="View"><i class="far fa-eye"></i> </button>  </a>
                                            @if(Auth::user()->user_type != 'organization')
                                            <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#myModalEdit-{{$CustomerClient->cust_client_id}}" id="show-modal"><i class="fa fa-edit"></i> </button>

                                            <button  @click.prevent="deleteItem('customerclientdeletepath',{{$CustomerClient->cust_client_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            @endif
                                            </form>                                           
                                            </div>
                                             <!-- modal -->
                                             <div id="myModalEdit-{{$CustomerClient->cust_client_id}}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Edit Customer Contact [{{ucfirst($CustomerClient->cust_client_fullname)}}]<strong></strong></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        
                                                    <edit_client :clientdata="{{json_encode($CustomerClient)}}"></edit_client>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /end modal -->
                                            </td>
                                            </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                    </div>
                                </div>
                            </div>
                            @endif     </div>
                    <!-- client import -->
            <div class="modal fade" id="importClient" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                        <h4>Import Contacts</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                            
                            <div class="modal-body bg-light">
                                <div class="alert alert-info shadow-sm">
                                    <p class="mb-0">Download <a href="{{ url('/sample/clients2.xlsx') }}">sample file</a></p>
                                </div>
                                {{-- <import_client :cust_id="{{json_encode($id)}}"/> --}}
                                <form action="{{ route('import',$id)}}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="col form-group">
                                        <label for="import-file">Select excel file to import*</label>
                                        <input name="file" id="import-file" type="file" class="form-control">
                                    </div>
                                    <div class="col form-group">
                                        <button type="submit" class="btn btn-success btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                        <button type="button" class="btn btn-danger btn-round btn-md" data-dismiss="modal">Close</button>
                                    </div>
                                </form>
                                
                                </div>
                            </div>
                        </div>
                    </div>
                <!-- /client import -->
                                      
            </div>
            </div>
            </div>
        </div>
       

         <!-- add user modal -->
     
      <div id="myModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Add Contact<strong></strong></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body panel-default bg-light">
                
                <client_component :cust_id="{{json_encode($id)}}"></client_component>
                                                                        
            </div>
        </div>
    </div>
    </div>
    <!-- /end modal -->
    </div>
    </div>
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    @endsection








    