<?php

namespace App\Models\fcmodels;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Notifications\CustomerResetPasswordNotification;
use Illuminate\Database\Eloquent\Model;
class AuditLog extends Authenticatable
{
    use Notifiable;
    protected $connection = 'mysql_newfc';
    public $timestamps = false;
    protected $guard = 'customer';
    protected $table = 'audit_log';
    protected $primaryKey = 'audit_log_id';
    
    protected $hidden = [
        'password',
    ];
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new CustomerResetPasswordNotification($token));
    }
    //
    protected $fillable = [
       'audit_log_id',
       'audit_module',
       'audit_activity',
       'user_category',
        'user_id'
    ];
}


