<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerClientGroup extends Model
{
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    //
    protected $fillable = [
        'client_grp_id',
        'customer_group_cust_group_id',
        'customer_client_cust_client_id'
    ];
    protected $primaryKey = 'client_grp_id';
    //clientgroup<> client relationshiop
    public function ClientGroupClient()
    {
        return $this->belongsTo(CustomerClient::class, 'customer_client_cust_client_id','cust_client_id');
    }
    //clientgroup<>group relationshiop
    public function ClientGroupGroup()
    {
        return $this->belongsTo(CustomerGroup::class, 'customer_group_cust_group_id','cust_group_id');
    }
}
