<?php

namespace App\Models\bmmodels;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Notifications\CustomerResetPasswordNotification;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Customer extends Authenticatable
{
    use Notifiable;
    use SoftDeletes;
    protected $connection = 'mysql_bmp';

    protected $table = 'customers';
    protected $guard = 'customer';
    protected $primaryKey = 'cust_id';
    
    protected $hidden = [
        'password', 'remember_token'
    ];
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new CustomerResetPasswordNotification($token));
    }
    //
    protected $fillable = [
       'cust_id',
        'cust_name',
        'cust_primary_contact_type',
        'cust_sec_contact',
        'email',///chenged
        'cust_username',
        'password',
        'cust_status',
        'cust_otp_status',
        'role_id',
        'cust_first_time',
        'get_sms',
        'get_email'
    ];
    //customer<>user relationship
    public function CustomerUsers()
    {
        return $this->hasMany(CustomerUser::class, 'customer_cust_id');
    }
    //customer<>client relationship
    public function CustomerCLients()
    {
        return $this->hasMany(CustomerClient::class, 'customer_cust_id');
    }
    //customer<>clientbatch relationship
    public function CustomerCLientBatches()
    {
        return $this->hasMany(ClientBatch::class, 'client_batch_customer_id');
    }
    //customer<>passreset relationship
    public function CustomerPasswordResets()
    {
        return $this->hasMany(CustomerPasswordReset::class, 'customer_cust_id');
    }
    //customer<>file relationship
    public function CustomerFiles()
    {
        return $this->hasMany(CustomerFile::class, 'customer_cust_id');
    }
    //customer<>wallet relationship
    public function CustomerWallet()
    {
        return $this->hasOne(CustomerWallet::class, 'customer_cust_id');
    }
    //customer rlshp <> client payment 
    public function CustomerClientPayment()
    {
        return $this->hasMany(CustomerClientPayment::class, 'customer_cust_id');
    }
    //customer Auth rlshp
    public function CustomersAuth()
    {
        return $this->hasMany(CustomerAuth::class, 'customer_cust_id');
    } 
    //customer<>rates relationship
    public function CustomerRates()
    {
        return $this->hasMany(Rate::class, 'customer_cust_id');
    }
    //customer<>business numbers relationships
    public function BusinessNumbers()
    {
        return $this->hasMany(BusinessNumber::class, 'business_customer_id');
    }
    public function custUser()
    {
        return $this->hasMany(App\Models\User::class, 'bulk_cust_id');
    }
}
