<?php

namespace App\Models\atmodels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IMELogs extends Model
{
    protected $connection = 'mysql_temp';
    protected $table = 'imelogs';
    public $primaryKey = 'ime_log_id';
    public $timestamps = false;
    protected  $fillable = [
        'log_id',
        'audit_module',
        'ShopID',
        'user_id',
        'activity_log',  
        'current_messages',
        'previous_messages',  
    ];
    // contact <>  group relationship
    public function LogsShop()
    {
        return $this->belongsTo(\App\Models\atmodels\Shop::class, 'ShopID');
    }

        // Logs <>  user relationship
        public function LogsUsers()
        {
            return $this->belongsTo(\App\Models\atmodels\User::class, 'user_id','id');
        }
}
