<?php

namespace App\Models\atmodels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
 
class DataBandles_Customer extends Model
{
    protected $connection = 'mysql_temp';
    protected $table = 'databandles_customers';
    public $primaryKey = 'contact_id';
    public $timestamps = false;
    protected  $fillable = [
        'contact_id',
        'customer_id',
        'fname',
        'contact',
        'group_id',  
        'ime',
    ];
    // contact <>  group relationship
    public function contactGroup()
    {
        return $this->belongsToMany(\App\Models\atmodels\DataBandles_Contacts_Group_Association::class, DataBandle_Contact_Group::class, 'group_id','group_id');
    }

    // contact group
    public function assogroupContacts()
    {
        return $this->hasMany(\App\Models\atmodels\DataBandles_Contacts_Group_Association::class, 'contact_id','contact_id');

    }

    // contact group
    public function groupAssoContacts()
    {
        return $this->hasMany(\App\Models\atmodels\DataBandle_Contact_Group::class, 'group_id','group_id');
    }

}
