<?php

namespace App\Imports\FCImports;

use App\Models\fcmodels\Contact;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
//batch inserts do not rollback all but the batch that failed 
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithValidation;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Log;
use DB;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class CustomImport implements ToCollection, WithValidation
{
    use Importable;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    //get cust id
    protected $id;
   

    public function __construct($id,$message) {
        $this->id = $id;
        $this->message = $message;
    }
    
    public function collection(Collection $rows)
    {
          Validator::make($rows->toArray(), [
             '*.0' => 'required',
         ])->validate();
         
        try
        {
            //check duplicates
            Log::info(array_slice($rows->toArray(),1));
            //die();
     //return back()->with('failure','One or more specified column names in message does not exist in the excel file');

            //get excel columns
            $tablecolumns=$rows[0];
            
            $cols=$tablecolumns->toArray();
            
            $regex = '~\{([^}]*)\}~'; 
            $string = $this->message;
            preg_match_all($regex, $string, $matches);
            $matchs = $matches[1];
            //check if text {name} exists
            $checkfields=[];
            $mitchs = $matches[1];
              
            foreach($mitchs as $mat)
            {
              
              if(!in_array($mat,$rows[0]->toArray()))
                {
                      dd($mat);
                   array_push($checkfields,$mat);
                 
                } 

            }
           // Log::info($checkfields);
            if(count($checkfields)>0){
                  return back()->with('failure','One or more specified column names'.json_encode($checkfields).' in message does not exist in the excel file');
         
            } 
            
            //other excel data
            $exceldata=array_slice($rows->toArray(),1);
            
            //if the table exists,drop the table then recreates
            Schema::dropIfExists('customtable_'.$this->id);
            
            //then create the schema
            
            Schema::create('customtable_'.$this->id, function (Blueprint $table) use ($cols) {
               $table->increments('id');
               foreach($cols as $col){
                   if($col == 'number')
                   {
                       $table->string($col, 25)->unique();
                   }
                   else
                   {
                       $table->longText($col);
                   }
               }
              $table->longText('sms')->nullable();
              $table->longText('reason')->nullable();
              $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
              $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));
              
            });
            
            $checkarray=count(Schema::getColumnListing('customtable_'.$this->id));
            
            $tablecolumns1=array_slice(Schema::getColumnListing('customtable_'.$this->id),0,$checkarray-4);
            //get the table columns
            $tablecolumns=array_slice($tablecolumns1,1);
            
            $arraytest=array();
            $item=array();
            
            foreach($exceldata as $data){
                
              array_push($item,array_combine($tablecolumns,$data));
              
            }
            
            //check 
            $d=[];
            
            foreach($item as $ts)
            {
            $arr_test =array();
            foreach($matches[1] as $m)
            {
                if(empty($ts[$m])){
                    
                    array_push($d,$m);
                }
                else{
                    array_push($arr_test,$ts[$m]);
                }
              
            }
          
            
            $newmessage=str_replace($matches[0],$arr_test,$this->message);
            
            $myitem=array('sms'=>$newmessage);
            
            $itemis = array_merge($ts,$myitem);
           
             DB::table('customtable_'.$this->id)->insert($itemis);
            
            }
            
            
              return redirect()->back()->with('success', 'Contacts Uploaded succesfully!');   
        
         
          return $item;
            
        }
        catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
            $failures = $e->failures();
            
            foreach ($failures as $failure) {
                $failure->row(); // row that went wrong
                $failure->attribute(); // heading row
                $failure->errors(); // Actual error messages from Laravel validator
                $failure->values(); // The values of the row that has failed.
            }
        }
        
        
    }
    public function rules(): array
    {
        
          return [
       
          //  '1' => 'required|regex:/(254)[0-9]{9}/',
        ];
     
    }
    public function customValidationMessages()
    {
        return [
       
            'number.max' => 'Phone number must be 12 characters of format "254712345678"',
            'number.min' => 'Phone number must be 12 characters of format "254712345678".'
        ];
    }
    
   
}
    