<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;

use App\Models\fcmodels\Sms_Template;
use App\Models\fcmodels\Department;
use App\Models\fcmodels\Organization;
use App\Models\fcmodels\Sms_template_columns;

use Auth;
use App\Models\AuditLog;
use App\Models\Wallet;

class SmsTemplateController extends Controller
{
  
    public function index()
    {
      if(Auth::guard('organization')->check())
      {
          $id = Auth::guard('organization')->user()->organization_id;
          $api_account = Auth::guard('organization')->user()->api_account;
      }
      else if(Auth::guard('web')->check())
      {
          $id = Auth::guard('web')->user()->organization_id;
          $api_account = Auth::guard('web')->user()->userOrg->api_account;
      }
      else{
            return abort('401');
        }
    
      $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
      $org = Organization::where('organization_id',$id)->pluck('organization_id');
           $sms_templates = Sms_Template::whereIn('organization_id',$org)->with('SmsTeporg')->get();
           //return  $sms_template;
           
            return view('sms_template.index',compact('sms_templates','wallet'));
 
    }



    //get departments
    public function getDepartments()
    {
        if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
        }
            $departments = Department::where('organization_id',$id)->get();
            return $departments;
    }


    //get TemplatesColumns
    public function getSms_template_columns()
    {
        if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
        }
            $Sms_template_columns = Sms_template_columns::where('organization_id',$id)->get();
            return $Sms_template_columns;
    }




   //get TemplatesColumns
    public function get_temp_sms()
    {
        if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
        }
            $Sms_temp_sms = Sms_Template::where('organization_id',$id)->get();
            return $Sms_temp_sms;
    }







//store
public function storeSmstemplate(Request $request)
{
     if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
        }
    $request->validate([
   
        'temp_name' => 'required|string',

                
            ]);
    $data = new Sms_Template();
    $data->organization_id = Auth::guard('organization')->user()->organization_id;
    $data->sms_template_id = $request->sms_template_id['sms_template_id'];
    $data->temp_name = $request->temp_name;
      $data->temp_sms = $request->temp_sms;
    //$data->organization_id = Auth::guard('organization')->user()->organization_id;
    

     //return $data;
    $data->save ();
    //log

    //$adminLog->save();
    
    return response()->json($data);
}




 //edit
 public function editInboxtag(Request $request)

 {

  //  try
    { 
        request()->validate([
            'tag_name'=> 'required',
  
        ]);
       // return $request;
    //current customer 
   
    $id = $request->id;
    $departmentdets = InboxTag::where('inbox_tag_id',$id)->get();
    //update
    $data = InboxTag::findOrFail($id);
   
   $data->department_id = $request->department_id['department_id'];
    $data->tag_name = $request->get('tag_name');




    $data->save();

     return $data;
        
    }
    
  //  catch (Exception $exception)
   // {
      //  return back()->withInput()
        //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
  //  }
 }

    
 //delete
 public function deletesms_template(Request $request,$id){
    //find user details to delete
    $admin = Sms_Template::where('sms_template_id',$id)->get();
    //set delete
    $deleteDepartment = Sms_Template::find($id);
    $deleteDepartment->delete();
    //set logging
    $adminLog = new AuditLog();
    $adminLog->audit_module = "sms_template";
    $adminLog->audit_activity = "SMS template of details: ".$admin." deleted by Admin ID#" .Auth::guard('organization')->user()->organization_id;
    
    $adminLog->user_category = "organization";
    $adminLog->user_id = Auth::guard('organization')->user()->organization_id; 
    $adminLog->save();
}




}
