<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use App\Models\fcmodels\Contact;
use App\Models\fcmodels\Currency_Expenditure;

use App\Models\fcmodels\Group;
use Auth;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;
class SmsController extends Controller
{
 
    public function index()
    {
        if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
            $api_account = Auth::guard('organization')->user()->api_account;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
            $api_account = Auth::guard('web')->user()->userOrg->api_account;
        }
        else{
            return abort('401');
        }
        
        
        
    $today = date('Y-m-d');
            
        $query =Currency_Expenditure::where('shopid',$api_account);
        $smscount=EloquentBuilder::to($query,request()->all())->count();
                
        $query =Currency_Expenditure::where('shopid',$api_account)->where('status','Sent');
        $smscountsent=EloquentBuilder::to($query,request()->all())->count();
                
        $query =Currency_Expenditure::where('shopid',$api_account)->where('status','Success');
        $smscountSuccess=EloquentBuilder::to($query,request()->all())->count();
                
        $query =Currency_Expenditure::where('shopid',$api_account)->where('status','failed');
        $smscountfailed=EloquentBuilder::to($query,request()->all())->count();
                
        $ivrcount = Ivr::count('organization_id');
        $total = $smscount+$ivrcount;

        $sms =  Currency_Expenditure::where('shopid',$api_account)->count();
        
        
            //     $account=Shop::where('ShopID',$api_account)->pluck('mpesa_account_name');
        $query =Currency_Expenditure::where('shopid',$api_account)->where('description','like',"%". $sms ."%")->where('sms','!=',"")->take(10);
        $trans=EloquentBuilder::to($query,request()->all())->get();
              
        
            $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
            $contacts = Contact::where('organization_id',$id)->with('contactGroup')->get();
           // return $contacts;
            return view('contacts.index',compact('trans','wallet'));
 
    }

    //get contacts
    public function getContacts()
    {
        if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
        }
            $contacts = Contact::where('organization_id',$id)->get();
            return $contacts;
    }


   //get getGroups
   public function getGroups()
   {
       
       if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
            $api_account = Auth::guard('organization')->user()->api_account;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
            $api_account = Auth::guard('web')->user()->userOrg->api_account;
        }
        else{
            return abort('401');
        }
       
       
       $groups = Group::where('organization_id',$id)->get();

       return $groups;
   }




    //store
    public function storeContact(Request $request)
    {
    
        if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
         
         
         
        }  
         
        // dd($request); 
      $no= $request->phone;
      // return $id;
        if((substr($no, 0, 4)=="+254")||(substr($no, 0, 3)=="254")||(substr($no, 0, 2)=="07")||(substr($no, 0, 1)=="7")){
                  
                    if(substr($no, 0, 4)=="+254"){
                        $request->phone="254" . substr($no, 4);
                    }
                    
                    elseif(substr($no, 0, 3)=="254"){
                        $request->phone="254" . substr($no, 3);  
                    }
                    elseif(substr($no, 0, 1)=="0"){
                        $request->phone="254" . substr($no, 1); 
                    }
                    elseif(substr($no, 0, 1)=="7"){
                        $request->phone="2547" . substr($no, 1); 
                    }
             }
       
        $request->validate([
       
            'name' => 'required',
    
                    
                ]);
        $data = new Contact();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->group_id = $request->group_id['group_id'];

        $data->organization_id = $id;

     
 
        // return $data;
        $data->save ();

        //log
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Organization";
        $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .$id;
       
        $adminLog->user_category = "Admin";
        $adminLog->user_id = $id;
        ;
        $adminLog->save();
        
        return response()->json($data);
    
}
        //edit
        public function editContacts(Request $request)

        {

        //  try
            { 
                request()->validate([
                    'name'=> 'required',
        
                ]);
               
            //current customer 
            $id=$request->contact_id;
            $contactsdets = Contact::where('contact_id',$id)->get();
            //update
            $data = Contact::findOrFail($id);
        
            $data->name = $request->get('name');
            $data->phone = $request->get('phone');
           // $data->group_id = $request->get('group_id');
            $data->group_id = $request->group_id['group_id'];
   //$dateea->group_id = $request->get('group_id');
 //$organization_id=Auth::guard('organization')->user()->organization_id;
  // dd($dateea);
            // log data
            $adminLog = new AuditLog();
            $adminLog->audit_module = "Organization";
            $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .$id;
        
            $adminLog->user_category = "Admin";
            $adminLog->user_id = $id;
            ;
            $adminLog->save();
            $data->save();

            return redirect()->back()
                ->with('success','Contacts Edited Succesfully.'); 
                
            }
        //  catch (Exception $exception)
        // {
            //  return back()->withInput()
                //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
        //  }
        }








        //delete
        public function deleteContact(Request $request,$id){
            //find user details to delete
            $Contact = Contact::where('contact_id',$id)->get();
            //set delete
            $deleteContact = Contact::find($id);
            $deleteContact->delete();
            //set logging
            $adminLog = new AuditLog();
            $adminLog->audit_module = "Organization";
            $adminLog->audit_activity = "Organization of details: ".$deleteContact." deleted by Admin ID#" .$id;
            
            $adminLog->user_category = "organization";
            $adminLog->user_id = $id; 
            $adminLog->save();
        }
}


