<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use Auth;
use Hash;
use App\Models\fcmodels\ManagementAccount;
use App\Models\fcmodels\AuditLog;
use Exception;

class ManagementAccountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //fetch all driverparticipants
        $management_accounts = ManagementAccount::all();
        return view('management_accounts.index', compact('management_accounts'));


    }







    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('management_accounts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    //vue add customer
    public function addCustomer(Request $request)
    {
        $this->validate($request, [
            'name'=> 'required',
            'primary' => 'required',
            'secondary' => 'required',
            'email' => 'required',
            'username' => 'required'
        ]);
        $customer = new ManagementAccount();
        $customer->cust_name = $request->name;
        $customer->cust_primary_contact_type = $request->primary;
        $customer->cust_sec_contact = $request->secondary;
        $customer->cust_email = $request->email;
        $customer->cust_username = $request->username;
        //default password is the username...USER be advised to change
        $customer->password = Hash::make($request->cust_username);
        $customer->cust_status = 1;
        // log data
        $customerLog = new AuditLog();
        $customerLog->audit_module = "Customer";
        $customerLog->audit_activity = "Customer ".$customer->cust_username ."added by Admin ID# " .Auth::user()->admin_id;
        
        $customerLog->user_category = "Admin";
        $customerLog->user_id = Auth::user()->admin_id;
        
        $customerLog->save();
        $customer->save();
        return response()->json($customer);
    }
    public function store(Request $request)
    {
        //add Traffic Police officers
       // try
       // {
 

        request()->validate([
            'organization'=> 'required',
            'api_account' => 'required',
            'email' => 'required',
            'username' => 'required',
     
        ]);
        $management_accounts = new ManagementAccount();
        $management_accounts->organization = $request->get('organization');
        $management_accounts->api_account = $request->get('api_account');
        $management_accounts->email = $request->get('email');
        $management_accounts->username = $request->get('username');
        $management_accounts->password = Hash::make($request->username);
        //default password is the username...USER be advised to change
        $management_accounts->status = $request->get('status');

      

        $management_accounts->added_by = 'admin';
        $management_accounts->ma_user_id = $request->get('ma_user_id');
     
        // log data
        $customerLog = new AuditLog();
        $customerLog->audit_module = "Management Accounts";
        $customerLog->audit_activity = "ManagementAccount ".$management_accounts->username ."added by Admin ID# " .Auth::user()->admin_id;
        
        $customerLog->user_category = "Admin";
        $customerLog->user_id = Auth::user()->admin_id;
        
        $customerLog->save();
        $management_accounts->save();
         return redirect()->back()
            ->with('success','ManagementAccount Added Succesfully.');
        //}
       // catch (Exception $exception)
       // {
           // return back()->withInput()
           //git   /   ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
      //  }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $driverparticipant = ManagementAccount::find($id);
        return view('cashbailbooklets.details',compact('cashbailbooklet'));
        

    }


  /**
     * Display the Driver resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function showdriver($id)
    {
        //
        $driverparticipant = ManagementAccount::find($id);
        return view('driverparticipants.details',compact('driverparticipant'));

    }










    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $customer = ManagementAccount::find($id);
        return view('customers.edit',compact('customer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        try
        { 
            request()->validate([
                'cust_name'=> 'required',
                'cust_primary_contact_type' => 'required',
                'cust_sec_contact' => 'required',
                'cust_email' => 'required',
                'cust_username' => 'required',
            ]);
        //currentTraffic police officerdetails
        $customerdets = ManagementAccount::where('cust_id',$id)->get();
        //update
        $customer = ManagementAccount::find($id);
       
        $customer->cust_name = $request->get('cust_name');
        $customer->cust_primary_contact_type = $request->get('cust_primary_contact_type');
        $customer->cust_sec_contact = $request->get('cust_sec_contact');
        $customer->cust_email = $request->get('cust_email');
        $customer->cust_username = $request->get('cust_username');
        $customer->cust_status = 1;
        // log data
        /*$customerLog = new AuditLog();
        $customerLog->audit_module = "Customer";
        $customerLog->audit_activity = "Customer details ".$customerdets." update to " .$customer. "by Admin ID# " .Auth::user()->admin_id;
        
        $customerLog->user_category = "Admin";
        $customerLog->user_id = Auth::user()->admin_id;
        
        $customerLog->save();*/
        $customer->save();

          return redirect()->back()
            ->with('success','Customer Edited Succesfully.'); 
            
        }
        catch (Exception $exception)
        {
            return back()->withInput()
                ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
      //  try
        {
        //findTraffic police officerdetails before delete
        $management_accounts = ManagementAccount::where('management_accounts_id',$id)->get();
        //set delete
        $deletemanagement_accounts = ManagementAccount::find($id);
        //set logging
        $customerLog = new AuditLog();
        $customerLog->audit_module = "ManagementAccount";
        $customerLog->audit_activity = "ManagementAccount  deleted by Admin ID# " .Auth::user()->admin_id;
        
        $customerLog->user_category = "Admin";
        $customerLog->user_id = Auth::user()->admin_id;
        
        //initiate log
        $customerLog->save();
        //initiate delete
        $deletemanagement_accounts->delete();
        //return message
        return redirect()->back()
            ->with('success','Management Accounts  Deleted Succesfully.');
        }
           // catch (Exception $exception)
       // {
          //  return back()->withInput()
            //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
      //  }
    }
}

