<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;

use App\Models\fcmodels\InboxTag;
use App\Models\fcmodels\Department;

use Auth;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;

class InboxTagController extends Controller
{
  
    public function index()
    {
      if(Auth::check())
      {
          $id = Auth::user()->organization_id;
          $api_account = Auth::user()->api_account;
      }
      else{
            return abort('401');
        }
    
      $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
      $depts = Department::where('organization_id',$id)->pluck('department_id');
           $inboxtags = InboxTag::whereIn('department_id',$depts)->with('tagsSDep')->get();
           //return  $inboxtags;
           
            return view('fcviews.inboxtags.index',compact('inboxtags','wallet'));
 
    }



    //get departments
    public function getDepartments()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
            $departments = Department::where('organization_id',$id)->get();
            return $departments;
    }



//store
public function storeInboxTag(Request $request)
{
    $request->validate([
   
        'tag_name' => 'required|string',

                
            ]);
    $data = new InboxTag();
  //  $data->organization_id = Auth::guard('organization')->user()->organization_id;
    $data->department_id = $request->department_id['department_id'];
    $data->tag_name = $request->tag_name;
    //$data->organization_id = Auth::guard('organization')->user()->organization_id;
    

    // return $data;
    $data->save ();
    //log
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
   
    $adminLog->user_category = "Admin";
    $adminLog->user_id = Auth::user()->organization_id;
    ;
    $adminLog->save();
    
    return response()->json($data);
}




 //edit
 public function editInboxtag(Request $request)

 {

  //  try
    { 
        request()->validate([
            'tag_name'=> 'required',
  
        ]);
       // return $request;
    //current customer 
   
    $id = $request->id;
    $departmentdets = InboxTag::where('inbox_tag_id',$id)->get();
    //update
    $data = InboxTag::findOrFail($id);
   
   $data->department_id = $request->department_id['department_id'];
    $data->tag_name = $request->get('tag_name');



    // log data
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
   
    $adminLog->user_category = "Admin";
    $adminLog->user_id = Auth::user()->organization_id;
    ;
    $adminLog->save();
    $data->save();

     return $data;
        
    }
    
  //  catch (Exception $exception)
   // {
      //  return back()->withInput()
        //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
  //  }
 }

    
 //delete
 public function deleteInboxtag($id){
     try
     {
        //find user details to delete
        $admin = InboxTag::findOrFail($id)->get();
        //set delete
        $deleteDepartment = InboxTag::findOrFail($id);
        $deleteDepartment->delete();
        //set logging
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Inboxtag";
        $adminLog->audit_activity = "Inboxtag of details: ".$admin." deleted by Admin ID#" .Auth::user()->organization_id;
        
        $adminLog->user_category = "organization";
        $adminLog->user_id = Auth::user()->organization_id; 
        $adminLog->save();
        return $deleteDepartment;
     }
     catch(\Exception $e)
     {
         return response()->json($e);
     }
}




}
