<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use App\Models\fcmodels\Contact;
use App\Models\fcmodels\Group;
use App\Models\bmmodels\CustomerClient;
use App\Models\atmodels\Airtime_contact;
use Auth;
use Log;
use EloquentBuilder;
use DB;

use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;
class ContactController extends Controller
{
 
    public function index()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
            $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
            $query = Contact::where('organization_id',$id)->with('contactGroup');
            $contacts=EloquentBuilder::to($query,request()->all())->paginate(15);
           // return $contacts;
            return view('fcviews.contacts.index',compact('contacts','wallet'));
 
    }

    //get contacts
    public function getContacts()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            
        }
        else{
            return abort('401');
        }
            $contacts = Contact::where('organization_id',$id)->get();
            return $contacts;
    }


   //get getGroups
   public function getGroups()
   {
       
       if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
       
       
       $groups = Group::where('organization_id',$id)->get();

       return $groups;
   }




    //store
    public function storeContact(Request $request)
    {
    
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        // dd($request); 
      $no= $request->phone;
      // return $id;
        if((substr($no, 0, 4)=="+254")||(substr($no, 0, 3)=="254")||(substr($no, 0, 2)=="07")||(substr($no, 0, 1)=="7")){
                  
                    if(substr($no, 0, 4)=="+254"){
                        $request->phone="254" . substr($no, 4);
                    }
                    
                    elseif(substr($no, 0, 3)=="254"){
                        $request->phone="254" . substr($no, 3);  
                    }
                    elseif(substr($no, 0, 1)=="0"){
                        $request->phone="254" . substr($no, 1); 
                    }
                    elseif(substr($no, 0, 1)=="7"){
                        $request->phone="2547" . substr($no, 1); 
                    }
             }
       
        $request->validate([
       
            'name' => 'required',
    
                    
                ]);
        $data = new Contact();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->group_id = $request->group_id['group_id'];

        $data->organization_id = $id;

     
 
        // return $data;
        $data->save ();

        //log
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Organization";
        $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .$id;
       
        $adminLog->user_category = "Admin";
        $adminLog->user_id = $id;
        ;
        $adminLog->save();
        
        return response()->json($data);
    
}
        //edit
        public function editContacts(Request $request)

        {

        //  try
            { 
                request()->validate([
                    'name'=> 'required',
        
                ]);
               
            //current customer 
            $id=$request->contact_id;
            $contactsdets = Contact::where('contact_id',$id)->get();
            //update
            $data = Contact::findOrFail($id);
        
            $data->name = $request->get('name');
            $data->phone = $request->get('phone');
           // $data->group_id = $request->get('group_id');
            $data->group_id = $request->group_id['group_id'];
            // log data
            $adminLog = new AuditLog();
            $adminLog->audit_module = "Organization";
            $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .$id;
        
            $adminLog->user_category = "Admin";
            $adminLog->user_id = $id;
            ;
            $adminLog->save();
            $data->save();

            return redirect()->back()
                ->with('success','Contacts Edited Succesfully.'); 
                
            }
        
        }





public function destroy() {
   $checked = Request::input('checked',[]);
   foreach ($checked as $id) {
        Todo::where("id",$id)->delete(); //Assuming you have a Todo model. 
   }
   //Or as @Alex suggested 
   Todo::whereIn($checked)->delete();
}


        //delete
        public function deleteContact(Request $request,$id){
            //find user details to delete
            $Contact = Contact::where('contact_id',$id)->get();
            //set delete
            $deleteContact = Contact::find($id);
            $deleteContact->delete();
            //set logging
            $adminLog = new AuditLog();
            $adminLog->audit_module = "Organization";
            $adminLog->audit_activity = "Organization of details: ".$deleteContact." deleted by Admin ID#" .$id;
            
            $adminLog->user_category = "organization";
            $adminLog->user_id = $id; 
            $adminLog->save();
        }
        
                //delete All Contacts
        public function deleteAllContact(Request $request,$id){
            
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
            
            
            //find user details to delete
            
           // return $oid;
            $Contact = Contact::where('organization_id',$oid)->get();
            //set delete
            $deleteContact = Contact::find($id);
            $deleteContact->delete();
            //set logging
            $adminLog = new AuditLog();
            $adminLog->audit_module = "Organization";
            $adminLog->audit_activity = "Organization of details: ".$deleteContact." deleted by Admin ID#" .$id;
            
            $adminLog->user_category = "organization";
            $adminLog->user_id = $id; 
            $adminLog->save();
        }
        
        
       public function deleteAll(Request $request)
        {
            if(Auth::check())
            {
                $id = Auth::user()->organization_id;
                $api_account = Auth::user()->api_account;
            }
            else{
                return abort('401');
            }
            $ids = $request->contact;
            
            DB::connection('mysql_newfc')->table("contacts")->whereIn('contact_id',$ids)->where('organization_id',$id)->delete();

            return redirect()->back()->with('success', 'Contact(s) Deleted successfully.'); 
          
            //return response()->json(['success'=>"Contacts Deleted successfully."]);

        }     
        
     //
     public function getAllContacts(){
    
         if(Auth::check())
        {
            
            if(Auth::user()->user_type == 'organization_user'){
                
                $id = Auth::user()->bulk_cust_id;
                
                $c=array();
                 
                if(Auth::user()->shop_id){
                    
                    $customer_id=Auth::user()->userShopUser['customer_id'];
                    $airtimecontacts=Airtime_contact::where('customer_id',$customer_id)->get(['contact AS phone','fname AS name','contact_id AS contact_id'])->toArray();
                    
                    foreach($airtimecontacts as $a){
                    $air_c['phone']=(int)"254".substr($a['phone'],-9);
                    $air_c['name']=$a['name'];
                    $air_c['contact_id']=$a['contact_id'];
                    array_push($c,$air_c);
                
                }
                    
                }
                
                $fcorg_id = Auth::user()->organization_id;
                $data = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->get(['cust_client_phone AS phone','cust_client_fullname AS name','cust_client_id AS contact_id'])->toArray();
                $contacts=Contact::where('organization_id',$fcorg_id)->get(['phone','name','contact_id'])->toArray();
               
                foreach($data as $a){
                    $b['phone']=(int)"254".$a['phone'];
                    $b['name']=$a['name'];
                    $b['contact_id']=$a['contact_id'];
                    array_push($c,$b);
                
                }
                
                $newdata=array_merge($contacts,$c);
        
        }
        else if(Auth::user()->user_type == 'organization'){
            $id = Auth::user()->bulk_cust_id;
            $c=array();
                 
                if(Auth::user()->shop_id){
                    
                    $customer_id=Auth::user()->userShopUser['customer_id'];
                    $airtimecontacts=Airtime_contact::where('customer_id',$customer_id)->get(['contact AS phone','fname AS name','contact_id AS contact_id'])->toArray();
               
                    
                    foreach($airtimecontacts as $a){
                    $air_c['phone']=(int)"254".substr($a['phone'],-9);
                    $air_c['name']=$a['name'];
                    $air_c['contact_id']=$a['contact_id'];
                    array_push($c,$air_c);
                
                }
                  
                }
            $fcorg_id = Auth::user()->organization_id;
            $data = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->get(['cust_client_phone AS phone','cust_client_fullname AS name','cust_client_id AS contact_id'])->toArray();
            $contacts=Contact::where('organization_id',$fcorg_id)->get(['phone','name','contact_id'])->toArray();
         
            foreach($data as $a){
                $b['phone']=(int)"254".$a['phone'];
                $b['name']=$a['name'];
                $b['contact_id']=$a['contact_id'];
                array_push($c,$b);
            
            }
            
            $newdata=array_merge($contacts,$c);
        }
            
            
            
            
        }
        else{
            return abort('401');
        }
           
            return $newdata;
     }
}


