<?php

namespace App\Http\Controllers\FCControllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Session;

class AdminLoginController extends Controller
{
    //
    public function __construct()
    {
        //defining our middleware for this controller
        $this->middleware('guest:admin',['except' => ['logout']]);
    }
    //function to show admin login form
    public function showLoginForm() {
        return view('auth.admin-login.login');
    }
    //function to login admins
    public function login(Request $request) {
         //validate the form data
         $this->validate($request,[
            'username' => 'required',
            'password' => 'required|min:6'
        ]);

       
        //check database connection and handle the exception
        try{
            $db=\DB::connection()->getPdo();
            
            //attempt to login the admins in
            if (Auth::guard('admin')->attempt(['admin_username' => $request->username, 'password' => $request->password], $request->remember)){
                //if successful redirect to admin dashboard
                $data=["status"=>"adminsuccess"];
                
                return response()->json($data);
            }
            $data=["status"=>"adminfailed"];
            //if unsuccessfull redirect back to the login for with form data
            //return redirect()->back()->withInput($request->only('username','remember'));
            return response()->json($data);
        }
        catch(\Exception $e) {

            return abort('504', 'Could not connect to the database.  Please check your configuration.');
            
        }
    }

    public function logout()
    {
        Auth::guard('admin')->logout();
        Session::forget('pgrbfHulQFZ6EYVt0zYLdC7hSWBTg9pYqKzNN7d7nuc=') ;// Removes a specific variable

        Auth::logout();
        Session::flush();
        header("cache-Control: no-store, no-cache, must-revalidate");
        header("cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
        Session::flush();
    // $request->session()->regenerate(true);
        Session::flash('succ_message', 'Logged out Successfully');
      //  return redirect('signin');

        return redirect('/admin/login');
       //return route('admin.login');
    }

}