<?php

namespace App\Exports;
use EloquentBuilder;
use Maatwebsite\Excel\Excel;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use App\Models\bundles\Data_Bundles_TopUp;
use Illuminate\Http\Request;
use Auth;
use Carbon\Carbon;

use Maatwebsite\Excel\Concerns\FromCollection;

class Data_Bundles_TopUpExport implements Responsable, FromCollection, WithHeadings, WithMapping
{
    use Exportable;
    protected $request;
    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */
    private $fileName = 'bundles_History.xlsx';

    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    // public function __construct($request)
    // {
    //     $this->request = $request;
    // }

    public function headings(): array
    {
        return [
            'contact',
            'customer',
            'qnty',
            'unit',
            'ime',
        ];
    }

    public function map($history): array
    {
        $contact = Data_Bundles_TopUp::All();
        return [
            $history->contact,
            $history->customer,
            $history->qnty,
            $history->unit,
            $history->ime,
        ];
    }

    public function collection()
    {
        // return Customer::all();
        $query = Data_Bundles_TopUp::All();
       // $history = EloquentBuilder::to($query, request()->all())->get();
        return $query;
    }
}
